#region usings
using System;
using System.ComponentModel.Composition;

using VVVV.PluginInterfaces.V1;
using VVVV.PluginInterfaces.V2;
using VVVV.Utils.VColor;
using VVVV.Utils.VMath;
using OVR;

using VVVV.Core.Logging;
#endregion usings

namespace VVVV.Nodes
{ 
	#region PluginInfo 
	[PluginInfo(Name = "OVRDevice", Category = "Devices", Help = "Basic template with one value in/out", Tags = "")]
	#endregion PluginInfo
	public class DevicesOVRDeviceNode : IPluginEvaluate, IPartImportsSatisfiedNotification
	{ 
		#region fields & pins
		[Input("Enabled")]
		IDiffSpread<bool> FEnabled;

		
		
		[Output("Output")]
		ISpread<Vector4D> FOutput;

		[Output("Working")]
		ISpread<bool> FWorking;
		
		
		[Output("InterpupillaryDistance")]
		ISpread<float> FInterpupillaryDistance;
		[Output("LensOffset")]
		ISpread<Vector2D> FLensOffset;
		[Output("VerticalFOV")]
		ISpread<float> FVerticalFOV;
		[Output("AspectRatio")]
		ISpread<float> FAspectRatio;
		[Output("DistK")]
		ISpread<Vector4D> FDistK;
		[Output("DistortionScale")]
		ISpread<float> FDistortionScale;
		
		
		[Output("Debug")]
		ISpread<string> FDebug;
		
		[Import()]
		ILogger FLogger;
		#endregion fields & pins 

		// PRIVATE MEMBERS
		
		private bool   UpdateCamerasDirtyFlag = false; 
		
		// private Camera CameraLeft, CameraRight = null;
		private float  IPD = 0.064f; 							// in millimeters
		private float  LensOffsetLeft, LensOffsetRight = 0.0f;  // normalized screen space
		private float  VerticalFOV = 90.0f;	 					// in degrees
		private float  AspectRatio = 1.0f;						
		private float  DistK0, DistK1, DistK2, DistK3 = 0.0f; 	// lens distortion parameters
		private float  DistortionScale = 0.0f;
		
		OVRDevice device;
		public void OnImportsSatisfied() {
			FEnabled.Changed += (active) => {
				if(active != null && active.SliceCount > 0)
				{
					if(active[0])
					{
						device = new OVRDevice();
						device.Awake();
						
						// init OVR
						FLogger.Log(LogType.Debug, OVRDevice.DisplayDeviceName);
						FLogger.Log(LogType.Debug, "" + OVRDevice.HResolution + ", " + OVRDevice.VResolution);
						
						DirQ = new Quaternion(7,2,5,3);
			
						InitCameraControllerVariables();
					}
					else {
						if(device != null) device.OnDestroy();
						device = null;
					}
				}
			};
			
			FDebug.SliceCount = 1;
			FDebug[0] = "";
		}
		
		float RiftPresentTimeout = 10.0f;
		void CheckIfRiftPresent()
		{
			bool HMDPresent = OVRDevice.IsHMDPresent();
			bool SensorPresent = OVRDevice.IsSensorPresent(0); // 0 is the main head sensor
			
			RiftPresentTimeout = 10.0f; // Keep message up for 10 seconds
				
			if((HMDPresent == false) && (SensorPresent == false))
				FDebug[0] = "NO HMD AND SENSOR DETECTED";
			else if (HMDPresent == false)
				FDebug[0] = "NO HMD DETECTED";
			else if (SensorPresent == false)
				FDebug[0] = "NO SENSOR DETECTED";
			else
				FDebug[0] = "HMD AND SENSOR DETECTED";
		}
		
		Quaternion DirQ;
		//called when data for any output pin is requested
		public void Evaluate(int SpreadMax)
		{
			// if(device == null) return;
			
			CheckIfRiftPresent();
			
			FOutput.SliceCount = SpreadMax;
			FWorking.SliceCount = 4;
			DirQ.x = 4;
			FWorking[0] = OVRDevice.GetOrientation(ref DirQ);
			
			FOutput.SliceCount = 1; 
			FOutput[0] = new Vector4D(DirQ.x, DirQ.y, DirQ.z, DirQ.w);
			
			FWorking[1] = OVRDevice.IsHMDPresent(); 
			FWorking[2] = OVRDevice.IsInitialized();
			FWorking[3] = OVRDevice.IsSensorPresent(0);
			
			// OVRDevice.Process
			//if(OVRDevice.IsInitialized())
			//	OVRDevice.ProcessLatencyInputs();
			
			//FLogger.Log(LogType.Debug, "hi tty!");
		}
		
		public void InitCameraControllerVariables()
		{
			// Get the IPD value (distance between eyes in meters)
			OVRDevice.GetIPD(ref IPD);
	
			// Get the values for both IPD and lens distortion correction shift. We don't normally
			// need to set the PhysicalLensOffset once it's been set here.
			OVRDevice.CalculatePhysicalLensOffsets(ref LensOffsetLeft, ref LensOffsetRight);
			
			// Using the calculated FOV, based on distortion parameters, yeilds the best results.
			// However, public functions will allow to override the FOV if desired
			VerticalFOV = OVRDevice.VerticalFOV();
			
			// Store aspect ratio as well
			AspectRatio = OVRDevice.CalculateAspectRatio();
			
			DistortionScale = OVRDevice.DistortionScale();
			
			OVRDevice.GetDistortionCorrectionCoefficients(ref DistK0, ref DistK1, ref DistK2, ref DistK3);
					
			// Get our initial world orientation of the cameras from the scene (we can grab it from 
			// the set FollowOrientation object or this OVRCameraController gameObject)
			
			//set vvvv values
			FInterpupillaryDistance.SliceCount = 1;
			FLensOffset.SliceCount = 1;
			FVerticalFOV.SliceCount = 1;
			FAspectRatio.SliceCount = 1;
			FDistK.SliceCount = 1;
			FDistortionScale.SliceCount = 1;
			
			FInterpupillaryDistance[0] = IPD;
			FLensOffset[0] = new Vector2D(LensOffsetLeft, LensOffsetRight);
			FVerticalFOV[0] = VerticalFOV;
			FAspectRatio[0] = AspectRatio;
			FDistK[0] = new Vector4D(DistK0, DistK1, DistK2, DistK3);
			FDistortionScale[0] = DistortionScale;
		}
	}
	
	
}
