#region usings
using System;
using System.ComponentModel.Composition;
using System.Threading;
using System.Net;
using VVVV.PluginInterfaces.V1;
using VVVV.PluginInterfaces.V2;
using VVVV.Utils.VColor;
using VVVV.Utils.VMath;
using OpenHardwareMonitor.Hardware;
using VVVV.Core.Logging;
using System.Diagnostics;
using System.Collections.Generic;
#endregion usings

namespace VVVV.Nodes
{
	#region PluginInfo
	[PluginInfo(Name = "OpenHardwareMonitor", Category = "String", Help = "HW Monitor", Tags = "Temperature,Load,Voltage", Author = "SoundReactor")]
	#endregion PluginInfo
	
	


	public class StringOpenHardwareMonitorNode : IPluginEvaluate
	{
		#region fields & pins
		[Input("check", IsBang = true)]
		ISpread<bool> FInput;
		
		[Output("HWMonitor HardwareItem")]
		ISpread<string> FOutput;

		[Output("HWMonitor SubHardware")]
		ISpread<string> FOutput2;
		
		[Output("Done")]
		ISpread<bool> FOutput3;

		[Import()]
		ILogger FLogger;
		#endregion fields & pins
			
		
		//called when data for any output pin is requested
		public void Evaluate(int SpreadMax)
		{
			
			
			if(FInput[0] == true)
			{
			
			//FLogger.Log(LogType.Debug, "Hardware Parsing START"); 
			FOutput3[0] = false;
				
			RunAsynchronously( () => { 	
				

			int spreadmaxim = 0;
			int spreadmaxim2 = 0;
			int jamestwo = 0;  
			int jamesone = 0;
					
	        MySettings settings = new MySettings(new Dictionary<string, string>
	        {
	            { "/intelcpu/0/temperature/0/values", "H4sIAAAAAAAEAOy9B2AcSZYlJi9tynt/SvVK1+B0oQiAYBMk2JBAEOzBiM3mkuwdaUcjKasqgcplVmVdZhZAzO2dvPfee++999577733ujudTif33/8/XGZkAWz2zkrayZ4hgKrIHz9+fB8/Iu6//MH37x79i9/+NX6N3/TJm9/5f/01fw1+fosnv+A/+OlfS37/jZ/s/Lpv9fff6Ml/NTef/yZPnozc5679b+i193//TQZ+/w2Dd+P9/sZeX/67v/GTf/b3iP3u4/ObBL//73+i+f039+D8Zk/+xz/e/P6beu2TQZju8yH8f6OgzcvPv/U3/Rb8+z/0f/9b/+yfaOn8079X6fr6Cws7ln/iHzNwflPv99/wyS/+xY4+v/evcJ+733+jJ5//Cw7/4ndy9Im3+U2e/Fbnrk31C93vrt/fyPvdb+N//hsF7/4/AQAA//9NLZZ8WAIAAA==" },
	            { "/intelcpu/0/load/0/values", "H4sIAAAAAAAEAOy9B2AcSZYlJi9tynt/SvVK1+B0oQiAYBMk2JBAEOzBiM3mkuwdaUcjKasqgcplVmVdZhZAzO2dvPfee++999577733ujudTif33/8/XGZkAWz2zkrayZ4hgKrIHz9+fB8/Iu6//MH37x79i9++mpwcv/md/9df89egZ/xX/ym/5y/4D37618Lv7ya//u+58+u+5d9/z7/5t/w9/6u5fP5bH/6av+eTkXyefXxp26ONaf/v/dG/sf39D/rvnv4e5vc/0IP56/waK/vuHzf5I38P8/tv+mv8Rbb9f0pwTF9/zr/1X9vP/8I//+/6Pf7Z30N+/zdf/HX29zd/859q4aCNP5b//U+U3/+7f+zXOjZwfqvDX/V7/o9/vPz+a1G/pv0f+fGlhfk7eZ//N3/0v28//5X0u/n8Cxq7+f1X/tHft20A5x8a/W5/02+BP36Nf+j/nv8XfzrT+c2//Ob4p3+vktvUhNs/+xcWikP6e/4T/5jS5M8/sL8vP/5ff49f/Ivl9//sHzv6PX/vXyG//9R/94/9HuZ34P/5vyC//3W/5e/1exa/k+Bw4bUBnU2bP4Xg/1bn0uafeTH6PatfKL//N3/0t2y/gG9+/8+IzqYNxmU+/+jwX7afY67/nwAAAP//GYSA31gCAAA=" },
	        });
	
				
	        Computer myComputer = new Computer(settings)
	        {
	            MainboardEnabled = true,
	            CPUEnabled = true,
	            RAMEnabled = true,
	            GPUEnabled = true,
	            FanControllerEnabled = true,
	            HDDEnabled = true
	        };
				
				
            myComputer.Open();

            foreach (var hardwareItem in myComputer.Hardware)
            {
                hardwareItem.Update();

 
            	if (hardwareItem.SubHardware.Length > 1)
                {
                	
                    foreach (IHardware subHardware in hardwareItem.SubHardware)
                    {
                        subHardware.Update();

                        foreach (var sensor in subHardware.Sensors)
                        {
                        	if (String.Format("{0} {1} = {2}", sensor.Name, sensor.Hardware, sensor.Value.HasValue ? sensor.Value.Value.ToString() : "no value").Length > 1)
                        	{
                        		spreadmaxim = spreadmaxim + 1;
                        	}	       
                        }
                    	FOutput2.SliceCount = spreadmaxim;
                    	
                    	foreach (var sensor in subHardware.Sensors)
                        {
                        	if (String.Format("{0} {1} = {2}", sensor.Name, sensor.Hardware, sensor.Value.HasValue ? sensor.Value.Value.ToString() : "no value").Length > 1)
                        	{
                        		FOutput2[jamesone] = String.Format("{0} {1} = {2}", sensor.Name, sensor.Hardware, sensor.Value.HasValue ? sensor.Value.Value.ToString() : "no value");
                        		jamesone = jamesone + 1;
                        	}
                            
                        }
                    }
                }
                else
                {
                	
                	foreach (var sensor in hardwareItem.Sensors)
                    {
                    		spreadmaxim2 = spreadmaxim2 + 1;                   	      
                    }
                	FOutput.SliceCount = spreadmaxim2;
                	             	
                    foreach (var sensor in hardwareItem.Sensors)
                    {
                    		FOutput[jamestwo] = String.Format("{0} {1} = {2}", sensor.Identifier, sensor.Hardware, sensor.Value.HasValue ? sensor.Value.Value.ToString() : "no value");
                    		jamestwo = jamestwo + 1;
                    }
         	
                }
            	
            	
            }
	
			}, () => { 
				
			//FLogger.Log(LogType.Debug, "Hardware Parsing is done"); 
			FOutput3[0] = true;
				
			} );
			
			}
			

			//FLogger.Log(LogType.Debug, "Logging to Renderer (TTY)");
		}
		
		public static void RunAsynchronously(Action method, Action callback) 
		{
		    ThreadPool.QueueUserWorkItem(_ =>
		    {
		        try {
		           method();
		        } 
		        catch (ThreadAbortException) { /* dont report on this */ } 

		        // note: this will not be called if the thread is aborted
		        if (callback!= null) callback();
		    });
		}	
		
	}
	
	
	public class MySettings : ISettings
    {
        private IDictionary<string, string> settings = new Dictionary<string, string>();

        public MySettings(IDictionary<string, string> settings)
        {
            this.settings = settings;
        }

        public bool Contains(string name)
        {
            return settings.ContainsKey(name);
        }

        public string GetValue(string name, string value)
        {
            string result;
            if (settings.TryGetValue(name, out result))
                return result;
            else
                return value;
        }

        public void Remove(string name)
        {
            settings.Remove(name);
        }

        public void SetValue(string name, string value)
        {
            settings[name] = value;
        }
    }
	
	
	
}
