#region usings
using System;
using System.Collections.Generic;
using System.ComponentModel.Composition;

using VVVV.PluginInterfaces.V1;
using VVVV.PluginInterfaces.V2;
using VVVV.Utils.Streams;
using VVVV.Utils.VColor;
using VVVV.Utils.VMath;

using VVVV.Core.Logging;
#endregion usings

namespace VVVV.Nodes
{
	#region PluginInfo
	[PluginInfo(Name = "AddZip", Category = "Value", Help = "Adds the Addendum spread to each single Input spread. Output SliceCount equals Input SliceCount. Dynamic Input and Output pin Count, check Inspektor.", Tags = "")]
	#endregion PluginInfo
	public class ValueAddZipNode : IPluginEvaluate, IPartImportsSatisfiedNotification
	{
		#region fields & pins

		[Input ("Addendum", DefaultValue = 0.0)]
		public ISpread<double> FAdd;
		
		public Spread<IIOContainer<ISpread<double>>> FInputs = new Spread<IIOContainer<ISpread<double>>>();

		public Spread<IIOContainer<ISpread<double>>> FOutputs = new Spread<IIOContainer<ISpread<double>>>();
		
		[Config("Input Count", DefaultValue = 2, MinValue = 2)]
		public IDiffSpread<int> FInputCountIn;

		[Config("Output Count", DefaultValue = 2, MinValue = 2)] //, Visibility = PinVisibility.False
		public IDiffSpread<int> FOutputCountIn;
		
		[Import()]
		public IIOFactory FIOFactory;
		public ILogger FLogger;
		#endregion fields & pins

		#region pin management
		public void OnImportsSatisfied()
		{
			FInputCountIn.Changed += HandleInputCountChanged;
			FOutputCountIn.Changed += HandleOutputCountChanged;
		}

		private void HandlePinCountChanged<T>(ISpread<int> countSpread, Spread<IIOContainer<T>> pinSpread, Func<int, IOAttribute> ioAttributeFactory) where T : class
		{
			pinSpread.ResizeAndDispose(countSpread[0], i =>
			{
				var ioAttribute = ioAttributeFactory(i + 1);
				return FIOFactory.CreateIOContainer<T>(ioAttribute);
			});
		}

		private void HandleInputCountChanged(IDiffSpread<int> sender)
		{
			HandlePinCountChanged(sender, FInputs, i => new InputAttribute(string.Format("Input {0}", i)));
			HandlePinCountChanged(sender, FOutputs, i => new OutputAttribute(string.Format("Output {0}", i)));
		}

		private void HandleOutputCountChanged(IDiffSpread<int> sender)
		{
			HandlePinCountChanged(sender, FOutputs, i => new OutputAttribute(string.Format("Output {0}", i)));
		}
		#endregion

		public void Evaluate(int SpreadMax)
		{
			for (int i = 0; i < FInputs.SliceCount; i++)
			{
				var inputSpread = FInputs[i].IOObject;
				var outputSpread = FOutputs[i].IOObject;
				for (int j = 0; j < inputSpread.SliceCount; j++)
				{
					inputSpread[j] += FAdd[j];
					outputSpread.AssignFrom(inputSpread);
				}
				
			}
		}
	}
}