/////project name
//  PS3 EYE MULTI

//////description
//  freeframe plugin.
//  You have access to more than one PS3 EYE CAMERA

//////licence
//  GNU Lesser General Public License (LGPL)
//  english: http://www.gnu.org/licenses/lgpl.html
//  german: http://www.gnu.de/lgpl-ger.html

//////language/ide
//  c++ cmake cross IDE

//////dependencies
//	opencv 1.0 libraries:
//	http://sourceforge.net/projects/opencvlibrary
//  
//  CL Eye Platformdriver	ver. 4.0
//  CL Eye Platform SDK		ver. 1.2
//  so you can use 2 Cameras, for more you need to pay
//  CL Eye Platform-Packs
//	http://codelaboratories.com/downloads/

//////initial author
//  Johannes Schmidt -> schmidt@kopffarben.de
//  www.kopffarben.de

////// VS Comment  ////////  USE F5 TO DEBUG  /////////////////////
//
//  Project/Properties/Debugging/Command (first line)
//    >> add path to vvvv.exe 
//		>> ie. pathtoVVVV\vvvv.exe
//  Project/Properties/Debugging/Argument (second line)
//	  >> add /o and path to PS3EyeMulti help.v4p
//		>> ie. /o "pathtoVVVV\freeframe\PS3EyeMulti help.v4p"
//  now you can DEBUG your PLUGIN (use Release and PRESS F5)
//
//
//  THIS FUNKTION CAN'T BE SET FROM CMAKE
//	SO YOU MUST FOLLOW THIS INSTRUCTION
//
///////////////////////////////////////////////////////////////////
 
//////edited by
//your name here

//includes
#include "PS3EyeMulti.h"

// Plugin Globals
PlugInfoStruct GPlugInfo;
PlugExtendedInfoStruct GPlugExtInfo;
ParamConstsStruct GParamConstants[NUM_PARAMS];
OutputConstsStruct GOutputConstants[NUM_OUTPUTS];

//OpenCV error handling defines:
#define CV_ErrModeLeaf    0
#define CV_ErrModeParent  1
#define CV_ErrModeSilent  2

// instanciate ps3EyeClass
ps3EyeClass	*ps3Eye[16]		= { NULL };
int			ps3Count		= CLEyeGetCameraCount();
bool		first;

int			gainValue;
int			exposureValue;
int			wbRedValue;
int			wbGreenValue;
int			wbBlueValue;

PlugInfoStruct* getInfo()
{
	GPlugInfo.APIMajorVersion = 1;			// number before decimal point in version nums
	GPlugInfo.APIMinorVersion = 1;			// this is the number after the decimal point
											// so version 0.511 has major num 0, minor num 501
	char ID[5] = "PS3M";					// this *must* be unique to your plugin
											// see www.freeframe.org for a list of ID's already taken
	char name[17] = "PS3_Eye_Multi";

	memcpy(GPlugInfo.uniqueID, ID, 4);
	memcpy(GPlugInfo.pluginName, name, 16);
	GPlugInfo.pluginType = FF_EFFECT;

	return &GPlugInfo;
}

DWORD initialise()
{
    cvSetErrMode(CV_ErrModeSilent);

    // populate the parameters constants structs
    GParamConstants[0].Type = FF_TYPE_STANDARD;
	GParamConstants[1].Type = FF_TYPE_BOOLEAN;
	GParamConstants[2].Type = FF_TYPE_BOOLEAN;	
	GParamConstants[3].Type = FF_TYPE_STANDARD;
	GParamConstants[4].Type = FF_TYPE_STANDARD;
	GParamConstants[5].Type = FF_TYPE_STANDARD;
	GParamConstants[6].Type = FF_TYPE_BOOLEAN;
	GParamConstants[7].Type = FF_TYPE_STANDARD;
	GParamConstants[8].Type = FF_TYPE_STANDARD;
	GParamConstants[9].Type = FF_TYPE_STANDARD;

	GParamConstants[0].Default =  0.0f;
	GParamConstants[1].Default =  1.0f;
	GParamConstants[2].Default =  1.0f;
	GParamConstants[3].Default = 30.0f;
	GParamConstants[4].Default =  0.0f;
	GParamConstants[5].Default =	0.0f;
	GParamConstants[6].Default =  1.0f;
	GParamConstants[7].Default =  0.5f;
	GParamConstants[8].Default =  0.5f;
	GParamConstants[9].Default =  0.5f;

	char tempName0[17] = "ID";
	char tempName1[17] = "ColorMode";
	char tempName2[17] = "HighResolution";
	char tempName3[17] = "FPS";
	char tempName4[17] = "GAIN  0=Auto";
	char tempName5[17] = "EXP    0=Auto";
	char tempName6[17] = "WB-Auto";
	char tempName7[17] = "WB-RED";
	char tempName8[17] = "WB-GREEN";
	char tempName9[17] = "WB-BLUE";

	memcpy(GParamConstants[0].Name, tempName0, 16);
	memcpy(GParamConstants[1].Name, tempName1, 16);
	memcpy(GParamConstants[2].Name, tempName2, 16);
	memcpy(GParamConstants[3].Name, tempName3, 16);
	memcpy(GParamConstants[4].Name, tempName4, 16);
	memcpy(GParamConstants[5].Name, tempName5, 16);
	memcpy(GParamConstants[6].Name, tempName6, 16);
	memcpy(GParamConstants[7].Name, tempName7, 16);
	memcpy(GParamConstants[8].Name, tempName8, 16);
	memcpy(GParamConstants[9].Name, tempName9, 16);


    // populate the output structs
    GOutputConstants[0].Type = 10;

	char outName0[17] = "Dummy Spread Out";
	memcpy(GOutputConstants[0].Name, outName0, 16);

	// instantiate PS3 Eye
	if (ps3Count > 0)
	{
		int i;
		for (i=0;i< ps3Count ;i++)
		{
			ps3Eye[i] = new ps3EyeClass(i);
			//ps3Eye[i]->Initialise((bool)GParamConstants[1].Default, (bool)GParamConstants[2].Default, (int)GParamConstants[3].Default);
		}
		first = false;
	}
	return FF_SUCCESS;
}

DWORD deInitialise()
{
	int i;
	for (i=0;i< ps3Count ;i++)
	{	
		ps3Eye[i]->DeInitialise();
	}
	
	return FF_SUCCESS;
}


plugClass::plugClass()
{
    FOutputs[0].SliceCount = 256;
    FOutputs[0].Spread = (float*) calloc(FOutputs[0].SliceCount, sizeof(float));

    InitializeCriticalSection(&CriticalSection);
}

plugClass::~plugClass()
{
	cvReleaseImage(&FPs3EyeHighResBgraCapture);
	cvReleaseImage(&FPs3EyeHighResGrayCapture);
	cvReleaseImage(&FPs3EyeHighResOutputImage);
	cvReleaseImage(&FPs3EyeLowResBgraCapture);
	cvReleaseImage(&FPs3EyeLowResGrayCapture);
	cvReleaseImage(&FPs3EyeLowResOutputImage);

    for (int i=0; i<NUM_OUTPUTS; i++) free(FOutputs[i].Spread);

    DeleteCriticalSection(&CriticalSection);
}

void plugClass::init()
{	
	// -> setting defaults for input values //
    for (int in=0; in<NUM_PARAMS; in++)
        FParams[in].Value=GParamConstants[in].Default;
	
	FImageSize.width	= FVideoInfo.frameWidth;
    FImageSize.height	= FVideoInfo.frameHeight;

	FCurrentImage		= cvCreateImageHeader(FImageSize, IPL_DEPTH_8U, 3);

	Ps3EyeSetIplImage();
	
}

void plugClass::Ps3EyeSetIplImage()
{
	FPs3EyeHighResBgraCapture		= cvCreateImage(cvSize(640, 480), IPL_DEPTH_8U, 4);
	FPs3EyeHighResGrayCapture		= cvCreateImage(cvSize(640, 480), IPL_DEPTH_8U, 1);
	FPs3EyeHighResOutputImage		= cvCreateImage(cvSize(640, 480), IPL_DEPTH_8U, 3);

	FPs3EyeLowResBgraCapture		= cvCreateImage(cvSize(320, 240), IPL_DEPTH_8U, 4);
	FPs3EyeLowResGrayCapture		= cvCreateImage(cvSize(320, 240), IPL_DEPTH_8U, 1);
	FPs3EyeLowResOutputImage		= cvCreateImage(cvSize(320, 240), IPL_DEPTH_8U, 3);

}

DWORD plugClass::setParameter(SetParameterStruct* pParam)
{
	FParams[pParam->index].Value = pParam->value;
	if (ps3Count > 0)
	{
		if ((pParam->index == 3)&&(FParams[3].Value != ps3Eye[(int)FParams[0].Value]->fps())||
			(pParam->index == 2)||
			(pParam->index == 1)||
			(!first))
		{
			first = true;
			ps3Eye[(int)FParams[0].Value]->Initialise((bool)FParams[1].Value, (bool)FParams[2].Value, (int)FParams[3].Value);
			gainValue		= (int)(FParams[4].Value * 80);
			exposureValue	= (int)(FParams[5].Value * 512);
			wbRedValue		= (int)(FParams[7].Value * 255);
			wbGreenValue	= (int)(FParams[8].Value * 255);
			wbBlueValue		= (int)(FParams[9].Value * 255);

			ps3Eye[(int)FParams[0].Value]->setGain(gainValue);
			ps3Eye[(int)FParams[0].Value]->setExposure(exposureValue);
			ps3Eye[(int)FParams[0].Value]->setAutoWB((bool) FParams[6].Value);
			ps3Eye[(int)FParams[0].Value]->setWbRed(wbRedValue);
			ps3Eye[(int)FParams[0].Value]->setWbGreen(wbGreenValue);
			ps3Eye[(int)FParams[0].Value]->setWbBlue(wbBlueValue);
		}
		
		if (pParam->index == 4)
		{

			gainValue = (int)(FParams[4].Value * 80);

			if (gainValue != ps3Eye[(int)FParams[0].Value]->getGain())
			{
				ps3Eye[(int)FParams[0].Value]->setGain(gainValue);
			}
		}
		if (pParam->index == 5)
		{

			exposureValue = (int)(FParams[5].Value * 512);

			if (exposureValue != ps3Eye[(int)FParams[0].Value]->getExposure())
			{
				ps3Eye[(int)FParams[0].Value]->setExposure(exposureValue);
			}
		}
		if (pParam->index == 6)
		{
			ps3Eye[(int)FParams[0].Value]->setAutoWB((bool) FParams[6].Value);
			if (FParams[6].Value == 0)
			{
				ps3Eye[(int)FParams[0].Value]->setWbRed(wbRedValue);
				ps3Eye[(int)FParams[0].Value]->setWbGreen(wbGreenValue);
				ps3Eye[(int)FParams[0].Value]->setWbBlue(wbBlueValue);
			}
		}
		if (pParam->index == 7)
		{

			wbRedValue   = (int)(FParams[7].Value * 255);

			if (wbRedValue != ps3Eye[(int)FParams[0].Value]->getWbRed())
			{
				ps3Eye[(int)FParams[0].Value]->setWbRed(wbRedValue);
			}
		}
		if (pParam->index == 8)
		{

			wbGreenValue = (int)(FParams[8].Value * 255);

			if (wbGreenValue != ps3Eye[(int)FParams[0].Value]->getWbGreen())
			{
				ps3Eye[(int)FParams[0].Value]->setWbGreen(wbGreenValue);
			}
		}
		if (pParam->index == 9)
		{

			wbBlueValue  = (int)(FParams[9].Value * 255);

			if (wbBlueValue != ps3Eye[(int)FParams[0].Value]->getWbBlue())
			{
				ps3Eye[(int)FParams[0].Value]->setWbBlue(wbBlueValue);
			}
		}
	} 

	return FF_SUCCESS;
}

// -> Function is called when spread input values (types 20, 21 or 22) are modified //
DWORD plugClass::setInput(InputStruct* pParam)
{
 	return FF_SUCCESS;
}


float* plugClass::getOutput(DWORD index)
{
    switch(index)
    {
       //compute the return values for the given index
       // case 0: memcpy(FOutputs[0].Spread, FPixelCount, 256 * sizeof(float));
    }
    return FOutputs[index].Spread;
}

DWORD plugClass::processFrame(LPVOID pFrame)
{
    EnterCriticalSection(&CriticalSection);

    //convert input image to opencv-image
    FCurrentImage->origin		= 1;
    FCurrentImage->imageData	= (char*)pFrame;
	
	// GET PS3 Eye ID
	int ID = (int)FParams[0].Value;

	// PS3 Eye Capture
	if (ps3Count > 0)
	{
		if (ps3Eye[ID]->found())
		{
			if (!ps3Eye[ID]->running())
			{
				ps3Eye[ID]->Start();
			} else {
				uchar **	pixels = NULL;
				int pointerAdress = ps3Eye[ID]->GetData();
				pixels = reinterpret_cast<uchar **>(pointerAdress);

				if (ps3Eye[ID]->highResMode())
				{
					if (ps3Eye[ID]->colorMode())
					{
						cvGetImageRawData(	FPs3EyeHighResBgraCapture,	pixels);
						cvCvtColor(			FPs3EyeHighResBgraCapture,	FPs3EyeHighResOutputImage,	CV_BGRA2BGR);
					} else {
						cvGetImageRawData(	FPs3EyeHighResGrayCapture,	pixels);
						cvCvtColor(			FPs3EyeHighResGrayCapture,	FPs3EyeHighResOutputImage,	CV_GRAY2BGR);
					}
					cvResize(				FPs3EyeHighResOutputImage,	FCurrentImage,				CV_INTER_NN);
				} else {
					if (ps3Eye[ID]->colorMode())
					{
						cvGetImageRawData(	FPs3EyeLowResBgraCapture,	pixels);
						cvCvtColor(			FPs3EyeLowResBgraCapture,	FPs3EyeLowResOutputImage,	CV_BGRA2BGR);
					} else {
						cvGetImageRawData(	FPs3EyeLowResGrayCapture,	pixels);
						cvCvtColor(			FPs3EyeLowResGrayCapture,	FPs3EyeLowResOutputImage,	CV_GRAY2BGR);
					}
					cvResize(				FPs3EyeLowResOutputImage,	FCurrentImage,				CV_INTER_NN);
				}
				cvFlip(FCurrentImage,FCurrentImage,0);
			}
		}
	}


    LeaveCriticalSection(&CriticalSection);
	return FF_SUCCESS;
}

DWORD plugClass::processFrameCopy(ProcessFrameCopyStruct* pFrameData)
{
    return FF_FAIL;
}

LPVOID instantiate(VideoInfoStruct* pVideoInfo)
{
	// Create local pointer to plugObject
	plugClass *pPlugObj;
	// create new instance of plugClass
	pPlugObj = new plugClass;

	// make a copy of the VideoInfoStruct
	pPlugObj->FVideoInfo.frameWidth		= pVideoInfo->frameWidth;
	pPlugObj->FVideoInfo.frameHeight	= pVideoInfo->frameHeight;
	pPlugObj->FVideoInfo.bitDepth		= pVideoInfo->bitDepth;

	// this shouldn't happen if the host is checking the capabilities properly
	pPlugObj->FVideoMode = pPlugObj->FVideoInfo.bitDepth;
	if (pPlugObj->FVideoMode >2 || pPlugObj->FVideoMode < 0) {
	  return (LPVOID) FF_FAIL;
	}

	pPlugObj->init();

	// return pointer to the plugin instance object we have created
	return (LPVOID) pPlugObj;
}
DWORD deInstantiate(LPVOID instanceID)
{
    //cvReleaseImage(&last);
	// declare pPlugObj - pointer to this instance
	plugClass *pPlugObj;

	// typecast LPVOID into pointer to a plugClass
	pPlugObj = (plugClass*) instanceID;

	delete pPlugObj; // todo: ? success / fail?

	return FF_SUCCESS;
}

LPVOID getExtendedInfo()
{

	GPlugExtInfo.PluginMajorVersion = 1;
	GPlugExtInfo.PluginMinorVersion = 10;

	// I'm just passing null for description etc for now
	// todo: send through description and about
	GPlugExtInfo.Description = NULL;
	GPlugExtInfo.About = NULL;

	// FF extended data block is not in use by the API yet
	// we will define this later if we want to
	GPlugExtInfo.FreeFrameExtendedDataSize = 0;
	GPlugExtInfo.FreeFrameExtendedDataBlock = NULL;

	return (LPVOID) &GPlugExtInfo;
}

DWORD getPluginCaps(DWORD index)
{
	switch (index) {

	case FF_CAP_16BITVIDEO:
		return FF_FALSE;

	case FF_CAP_24BITVIDEO:
		return FF_TRUE;

	case FF_CAP_32BITVIDEO:
		return FF_FALSE;

	case FF_CAP_PROCESSFRAMECOPY:
		return FF_FALSE;

	case FF_CAP_MINIMUMINPUTFRAMES:
		return NUM_INPUTS;

	case FF_CAP_MAXIMUMINPUTFRAMES:
		return NUM_INPUTS;

	case FF_CAP_COPYORINPLACE:
		return FF_FALSE;

	default:
		return FF_FALSE;
	}
}

float plugClass::getParameter(DWORD index)
{
	return FParams[index].Value;
}

DWORD plugClass::getOutputSliceCount(DWORD index)
{
	return FOutputs[index].SliceCount;
}
/////////////////////////////////////////////////////////////////////////////////


DWORD getNumParameters()
{
	return NUM_PARAMS;
}

DWORD getNumOutputs()
{
	return NUM_OUTPUTS;
}

char* getParameterName(DWORD index)
{
	return GParamConstants[index].Name;
}

float getParameterDefault(DWORD index)
{
	return GParamConstants[index].Default;
}

unsigned int getParameterType(DWORD index)
{
	return GParamConstants[index].Type;
}

unsigned int getOutputType(DWORD index)
{
	return GOutputConstants[index].Type;
}

char* getOutputName(DWORD index)
{
	return GOutputConstants[index].Name;
}

char* plugClass::getParameterDisplay(DWORD index)
{
	// fill the array with spaces first
	for (int n=0; n<16; n++)
    {
		FParams[index].DisplayValue[n] = ' ';
	}
	sprintf(FParams[index].DisplayValue, "%f",FParams[index].Value);
	return FParams[index].DisplayValue;
}

DWORD plugClass::setThreadLock(DWORD Enter)
{
	if (*(bool*) Enter)
	  EnterCriticalSection(&CriticalSection);
    else
      LeaveCriticalSection(&CriticalSection);

    return FF_SUCCESS;
}