//////project name
//TemplateExtOpenCV

//////description
//freeframe plugin.
//simple template using freeframe 1.0 extended functionality
//for spreaded in- and outputs
//see: http://vvvv.org/documentation/freeframeextendedspecification
//and OpenCV

//////licence
//GNU Lesser General Public License (LGPL)
//english: http://www.gnu.org/licenses/lgpl.html
//german: http://www.gnu.de/lgpl-ger.html

//////language/ide
//c++/Code::Blocks

//////initial author
//joreg -> joreg@gmx.at

//////edited by
//your name here

//freeframe includes
#include "FreeFrame.h"

//opencv includes
#include <cv.h>
#include <highgui.h>
#include <string.h>
#include <string>

#include <stdio.h>

//CL EYE Multicam includes
#include "CLEyeMulticam.h"

#include "ps3EyeClass.h"

using namespace std;

//pin constants
#define NUM_INPUTS 1  //number of video inputs

#define NUM_PARAMS 10  //number of input pins
#define NUM_OUTPUTS 1 //number of output pins


// implementation specific definitions

typedef struct ParamConstsStructTag {
    unsigned int Type;
	float Default;
	char Name[16];
} ParamConstsStruct;

typedef struct ParamStructTag {
	float Value;
	char DisplayValue[16];
} ParamStruct;

typedef struct OutputConstsStructTag {
    unsigned int Type;
    char Name[16];
} OutputConstsStruct;

typedef struct OutputStructTag {
	DWORD SliceCount;
    float* Spread;
} OutputStruct;

typedef struct InputStructTag {
	DWORD Index;
	DWORD SliceCount;
	double* Spread;
} InputStruct;

typedef struct VideoPixel24bitTag {
	BYTE red;
	BYTE green;
	BYTE blue;
} VideoPixel24bit;


// PluginInstance Object - these calls relate to instances of plugObj
// created by FF_INSTANTIATE
class plugClass
{
public:
    plugClass();
    ~plugClass();

	void init();

	char* getParameterDisplay(DWORD index);
	DWORD setParameter(SetParameterStruct* pParam);
	float getParameter(DWORD index);

	//freeframe 1.0 extended. see: http://vvvv.org/tiki-index.php?page=FreeFrameExtendedSpecification
    DWORD getOutputSliceCount(DWORD index);
    float* getOutput(DWORD index);
    DWORD setInput(InputStruct* pParam);
    DWORD setThreadLock(DWORD Enter);
    //-end freeframe 1.0 extended

	DWORD processFrame(LPVOID pFrame);
	DWORD processFrameCopy(ProcessFrameCopyStruct* pFrameData);

	ParamStruct FParams[NUM_PARAMS];
	OutputStruct FOutputs[NUM_OUTPUTS];

	VideoInfoStruct FVideoInfo;

	int FVideoMode;

private:
    void loadMask();

    CRITICAL_SECTION CriticalSection;
    CvSize FImageSize;

    IplImage* FCurrentImage;

    IplImage* FPs3EyeHighResBgraCapture;
	IplImage* FPs3EyeHighResGrayCapture;
	IplImage* FPs3EyeHighResOutputImage;
	IplImage* FPs3EyeLowResBgraCapture;
	IplImage* FPs3EyeLowResGrayCapture;
	IplImage* FPs3EyeLowResOutputImage;

	void Ps3EyeSetIplImage();
};

//Ps3Eye 
/*
void Ps3EyeInitialise(int cameraNr, bool colorMode, bool highResMode, float fps);
void Ps3EyeDeInitialise();
void Ps3EyeStart();
void Ps3EyeStop();
*/
// Function prototypes - Global Plugin Functions that lie outside the instance object
// see http://freeframe.sourceforge.net/spec.html for details

PlugInfoStruct*	getInfo();

DWORD	initialise();

DWORD	deInitialise();

DWORD	getNumParameters();

char*	getParameterName(DWORD index);

float	getParameterDefault(DWORD index);

unsigned int getParameterType(DWORD index);

DWORD	getPluginCaps(DWORD index);

LPVOID instantiate(VideoInfoStruct* pVideoInfo);

DWORD deInstantiate(LPVOID instanceID);

LPVOID getExtendedInfo();

//freeframe 1.0 extended. see: http://vvvv.org/tiki-index.php?page=FreeFrameExtendedSpecification
DWORD	getNumOutputs();
unsigned int getOutputType(DWORD index);
char*	getOutputName(DWORD index);



