#include "ps3EyeClass.h"

#define MAX_PS3EYE 2
	
	CLEyeCameraInstance		ps3EyeClass::_cam[MAX_PS3EYE];
	GUID					ps3EyeClass::_cameraGUID[MAX_PS3EYE];
	CLEyeCameraColorMode	ps3EyeClass::_mode[MAX_PS3EYE];
	CLEyeCameraResolution	ps3EyeClass::_resolution[MAX_PS3EYE];
	float					ps3EyeClass::_fps[MAX_PS3EYE];
	bool					ps3EyeClass::_found[MAX_PS3EYE];
	bool					ps3EyeClass::_running[MAX_PS3EYE];
	bool					ps3EyeClass::_colorMode[MAX_PS3EYE];
	bool					ps3EyeClass::_highResMode[MAX_PS3EYE];
	PBYTE					ps3EyeClass::ps3EyeBuffer[MAX_PS3EYE];


ps3EyeClass::ps3EyeClass(int id, bool _debugging)
{	
	_id				= id;
	_found[_id]		= false;
	_running[_id]	= false;	
	_debug			= _debugging;
}

ps3EyeClass::~ps3EyeClass()
{
	debug(0,"DE-INSTANTIATED !!!!");
	delete [] ps3EyeBuffer;
	DeInitialise();
}


void ps3EyeClass::Initialise(bool colorMode, bool highResMode, float fps)
{
	DeInitialise();
	_count = CLEyeGetCameraCount();

	// get GUID
	if ((_id < _count) && (_id >= 0)) 
	{
		_cameraGUID[_id] = CLEyeGetCameraUUID(_id);
		_found[_id] = true;
	} else {
		_id	= 0;
		_cameraGUID[_id] = CLEyeGetCameraUUID(_id);
		_found[_id]  = true;
	}

	// set ColorMode and RawMode
	if (colorMode)
	{
		_colorMode[_id]		= true;
		//_mode[_id]		= CLEYE_COLOR_RAW;
		_mode[_id]			= CLEYE_COLOR_PROCESSED;
	} else {
		_colorMode[_id]		= false;
		//_mode[_id]		= CLEYE_MONO_RAW;
		_mode[_id]			= CLEYE_MONO_PROCESSED;
	}
	
	// set HighResMode
	if (highResMode)
	{
		_highResMode[_id]	= true;
		_resolution[_id]	= CLEYE_VGA;
	}
	else
	{
		_highResMode[_id]	= false;
		_resolution[_id]	= CLEYE_QVGA;
	}
	

	// set fps
	_fps[_id]	= fps;


	debug(5);debug(1);debug(2);debug(3);debug(4);

	createBuffer();
	createCam();

}

void ps3EyeClass::DeInitialise()
{
	int i;
	for (i=0;i<MAX_PS3EYE;i++)
	{
		if (_cam[_id] != NULL)
		{
			Stop();
			CLEyeDestroyCamera(_cam[_id]);
			_cam[_id] = NULL;
		}
	}

}

void ps3EyeClass::Start()
{
	if (!_running[_id])
	{
		if (_cam[_id] != NULL)
		{		
			_running[_id] = true;
			CLEyeCameraStart(_cam[_id]);
			debug(6);
		}
	}
}

void ps3EyeClass::createCam()
{
	// Create PS3 Eye	
	_cam[_id] = CLEyeCreateCamera(_cameraGUID[_id], _mode[_id], _resolution[_id], _fps[_id]);

	//CLEyeSetCameraParameter(_cam[_id], CLEYE_GAIN, 10);
	//CLEyeSetCameraParameter(_cam[_id], CLEYE_EXPOSURE, 511);
}

void ps3EyeClass::createBuffer()
{
	if (_highResMode[_id])
	{
		if (_colorMode[_id])
		{
			ps3EyeBuffer[_id]	= new BYTE[640*480*4];
			debug(8);
		} else {
			ps3EyeBuffer[_id]	= new BYTE[640*480*1];
			debug(9);
		}
	} else {
		if (_colorMode[_id])
		{
			ps3EyeBuffer[_id]	= new BYTE[320*240*4];
			debug(10);
		} else {
			ps3EyeBuffer[_id]	= new BYTE[320*240*1];
			debug(11);
		}
	}
}

int ps3EyeClass::GetData()
{


	CLEyeCameraGetFrame(_cam[_id], ps3EyeBuffer[_id]);
	int output = (int) &ps3EyeBuffer[_id];
	return	output;
}

void ps3EyeClass::Stop()
{
	if (_running[_id])
	{
		if (_cam[_id] != NULL)
		{	
			_running[_id] = false;
			CLEyeCameraStop(_cam[_id]);
		}
	}
}

void ps3EyeClass::setGain(int value)
{
	if (value == (0))
	{
		CLEyeSetCameraParameter(_cam[_id],CLEYE_AUTO_GAIN,true);
		if (_debug)
		{
			char buffer[100];
			sprintf(buffer, "PS3 EYE %i AUTO GAIN = TRUE", _id);
			debug(0,buffer);
		}
	} else {
		if ((value>=1) && (value<=80))
		{
			if (_debug)
			{
				char buffer[100];
				sprintf(buffer, "PS3 EYE %i GAIN = %i", _id, value);
				debug(0,buffer);
			}
			CLEyeSetCameraParameter(_cam[_id],CLEYE_AUTO_GAIN,false);
			CLEyeSetCameraParameter(_cam[_id],CLEYE_GAIN,(value-1));
		}
	}
}
int ps3EyeClass::getGain()
{
	if (CLEyeGetCameraParameter(_cam[_id],CLEYE_AUTO_GAIN))
	{
		return (0);
	} else {
		return (CLEyeGetCameraParameter(_cam[_id],CLEYE_GAIN) + 1);
	}
}
void ps3EyeClass::setExposure(int value)
{
	if (value == (0))
	{
		CLEyeSetCameraParameter(_cam[_id],CLEYE_AUTO_EXPOSURE,true);
		if (_debug)
		{
			char buffer[100];
			sprintf(buffer, "PS3 EYE %i AUTO EXPOSURE = TRUE", _id);
			debug(0,buffer);
		}
	} else {
		if ((value>=1) && (value<=512))
		{
			if (_debug)
			{
				char buffer[100];
				sprintf(buffer, "PS3 EYE %i EXPOSURE = %i", _id, value);
				debug(0,buffer);
			}
			CLEyeSetCameraParameter(_cam[_id],CLEYE_AUTO_EXPOSURE,false);
			CLEyeSetCameraParameter(_cam[_id],CLEYE_EXPOSURE,(value-1));
		}
	}
}

int ps3EyeClass::getExposure()
{
	if (CLEyeGetCameraParameter(_cam[_id],CLEYE_AUTO_EXPOSURE))
	{
		return (0);
	} else {
		return (CLEyeGetCameraParameter(_cam[_id],CLEYE_EXPOSURE) + 1);
	}
}

void ps3EyeClass::setAutoWB(bool value)
{
	CLEyeSetCameraParameter(_cam[_id], CLEYE_AUTO_WHITEBALANCE, value);
	if (_debug)
	{	
		char buffer[100];
		if (value)
			sprintf(buffer, "PS3 EYE %i AUTO WHITEBALANCE = TRUE", _id);
		else 
			sprintf(buffer, "PS3 EYE %i AUTO WHITEBALANCE = FALSE", _id);
		debug(0,buffer);
	}
}

void ps3EyeClass::setWbRed(int value)
{
	if ((value>=0) && (value<=255))
	{
		if (_debug)
		{
			char buffer[100];
			sprintf(buffer, "PS3 EYE %i WB RED   = %i", _id, value);
			debug(0,buffer);
		}
		CLEyeSetCameraParameter(_cam[_id],CLEYE_WHITEBALANCE_RED,value);
	}
}

int ps3EyeClass::getWbRed()
{
	return CLEyeGetCameraParameter(_cam[_id],CLEYE_WHITEBALANCE_RED);
}

void ps3EyeClass::setWbGreen(int value)
{
	if ((value>=0) && (value<=255))
	{
		if (_debug)
		{
			char buffer[100];
			sprintf(buffer, "PS3 EYE %i WB GREEN = %i", _id, value);
			debug(0,buffer);
		}
		CLEyeSetCameraParameter(_cam[_id],CLEYE_WHITEBALANCE_GREEN,value);
	}
}

int ps3EyeClass::getWbGreen()
{
	return CLEyeGetCameraParameter(_cam[_id],CLEYE_WHITEBALANCE_GREEN);
}

void ps3EyeClass::setWbBlue(int value)
{
	if ((value>=0) && (value<=255))
	{
		if (_debug)
		{
			char buffer[100];
			sprintf(buffer, "PS3 EYE %i WB BLUE  = %i", _id, value);
			debug(0,buffer);
		}
		CLEyeSetCameraParameter(_cam[_id],CLEYE_WHITEBALANCE_BLUE,value);
	}
}

int ps3EyeClass::getWbBlue()
{
	return CLEyeGetCameraParameter(_cam[_id],CLEYE_WHITEBALANCE_BLUE);
}

void ps3EyeClass::debug(int _status, char _message[])
{
	if (_debug)
	{
		char psClass[]	= "         >>> PS3 EYE CLASS >>> ";
		char endln[]	= "\n";
		char message[100];
		char output[200];
	 
		switch(_status)
		{
		case 0:
			strcpy(message, _message);
			break;
		case 1:
			if (_found[_id])
				sprintf(message, "PS3 EYE %i FOUND", _id);
			else
				sprintf(message, "PS3 EYE %i NOT FOUND", _id);
			break;
		case 2:
			if (_running[_id])
				sprintf(message, "PS3 EYE %i RUNNING", _id);
			else
				sprintf(message, "PS3 EYE %i NOT RUNNING", _id);
			break;
		case 3:
			if (_colorMode[_id])
				sprintf(message, "PS3 EYE %i COLOR MODE", _id);
			else
				sprintf(message, "PS3 EYE %i MONOCROM MODE", _id);
			break;
		case 4:
			if (_highResMode[_id])
				sprintf(message, "PS3 EYE %i HIGHRES MODE", _id);
			else
				sprintf(message, "PS3 EYE %i LOWRES MODE", _id);
			break;
		case 5:
				sprintf(message, "PS3 EYE   CONNECTED -> COUNT %i", CLEyeGetCameraCount());
			break;
		case 6:
				sprintf(message, "PS3 EYE %i STARTED", _id);
			break;
		case 7:
				sprintf(message, "PS3 EYE %i INSTANTIATED", _id);
			break;
		case 8:
				sprintf(message, "PS3 EYE %i BYTE[640*480*4] BUFFER INIT", _id);
			break;
		case 9:
				sprintf(message, "PS3 EYE %i BYTE[640*480*1] BUFFER INIT", _id);
			break;
		case 10:
				sprintf(message, "PS3 EYE %i BYTE[320*240*4] BUFFER INIT", _id);
			break;
		case 11:
				sprintf(message, "PS3 EYE %i BYTE[320*240*1] BUFFER INIT", _id);
			break;
		}
		
		strcpy(output, psClass);
		strcpy(output + strlen(psClass), message);
		strcpy(output + strlen(psClass) + strlen(message), endln);

		OutputDebugString(output);
	}
}

int  ps3EyeClass::id()
{
	return _id;
}
int  ps3EyeClass::count()
{
	return _count;
}
int  ps3EyeClass::fps()
{
	return (int)_fps[_id];
}
bool ps3EyeClass::running()
{
	return _running[_id];
}
bool ps3EyeClass::found()
{
	return _found[_id];
}
bool ps3EyeClass::colorMode()
{
	return _colorMode[_id];
}
bool ps3EyeClass::highResMode()
{
	return _highResMode[_id];
}