//freeframe includes
#include "FreeFrame.h"

#include <string.h>
#include <string>
#include <stdio.h>

//CL EYE Multicam includes
#include "CLEyeMulticam.h"

using namespace std;


class ps3EyeClass
{
	static CLEyeCameraInstance		_cam[];
	static GUID						_cameraGUID[];
	static CLEyeCameraColorMode		_mode[];
	static CLEyeCameraResolution	_resolution[];

	static float					_fps[];
	static bool						_found[];
	static bool						_running[];
	static bool						_colorMode[];
	static bool						_highResMode[];

	static PBYTE					ps3EyeBuffer[];

public:
    ps3EyeClass(int id, bool _debugging = true);
	~ps3EyeClass();

	void Initialise(bool colorMode, bool highResMode, float fps);
	void DeInitialise();
	void Start();
	void createCam();
	void Stop();
	CLEyeCameraInstance getCam();

	int  GetData();
	void createBuffer();

	bool found();
	bool running();
	bool colorMode();
	bool highResMode();
	int  id();
	int  count();
	int	 fps();

	void setGain(int value);
	int  getGain();
	void setExposure(int value);
	int  getExposure();

	void setAutoWB(bool value);
	void setWbRed(int value);
	int  getWbRed();
	void setWbGreen(int value);
	int  getWbGreen();
	void setWbBlue(int value);
	int  getWbBlue();


	
	void exp(float value);

	void	debug(int _status = 0, char _message[] = "");

private:

	int		_id;
	int		_count;


	bool	_debug;	
};