# include this file only once
IF(LIBRARYCOMMON)
	return()
ENDIF(LIBRARYCOMMON)

# require calling cmake from the top level directory
IF(${CMAKE_PROJECT_NAME} STREQUAL "Project")
	MESSAGE(FATAL_ERROR "Please use the toplevel CMakeLists.txt, exiting...")
ENDIF(${CMAKE_PROJECT_NAME} STREQUAL "Project")

# for CMake Version 2.6 or above the policy for adding search paths to the linker has changed
# thus the policy is set to the old behavior explicitly here for now
IF(COMMAND cmake_policy)
	IF(POLICY CMP003)
		cmake_policy(SET CMP0003 OLD)
	ENDIF(POLICY CMP003)
	IF(POLICY CMP0011)
		cmake_policy(SET CMP0011 NEW)
	ENDIF(POLICY CMP0011)
ENDIF(COMMAND cmake_policy)


SET(LIBRARYCOMMON TRUE)

SET(LIBRARY_POSTFIX_DEBUG "_d")
SET(LIBRARY_POSTFIX_PUBLIC "S")
SET(LIBRARY_POSTFIX_PRIVATE "B")


INCLUDE(OutOfSourceBuild)

INCLUDE(BuildTypes)

INCLUDE(CompileDefinitions)

INCLUDE(CompilerFlags)

# always include the current directory when searching for includes
INCLUDE_DIRECTORIES(
	${CMAKE_SOURCE_DIR}
	${CMAKE_CURRENT_SOURCE_DIR}
	${CMAKE_BINARY_DIR}
)

IF(${CMAKE_BUILD_TYPE})
	MESSAGE(FATAL_ERROR "Build type is empty.")
ENDIF(${CMAKE_BUILD_TYPE})

# these two lines should be deprecated in cmake 2.6 but the new alternative setup (see below) does not work here
SET(EXECUTABLE_OUTPUT_PATH "${CMAKE_BINARY_DIR}/bin")
SET(LIBRARY_OUTPUT_PATH "${CMAKE_BINARY_DIR}/../freeframe")

SET(ARCHIVE_OUTPUT_DIRECTORY "${CMAKE_BINARY_DIR}/lib")
SET(LIBRARY_OUTPUT_DIRECTORY "${CMAKE_BINARY_DIR}/lib")
SET(RUNTIME_OUTPUT_DIRECTORY "${CMAKE_BINARY_DIR}/bin")



