# On success this script defines
# OPENCV_INCLUDES              location of cv.h cvaux.h cxcore.h highgui.h
# OPENCV_LIBRARIES             full path to cv cvaux cxcore highgui libraries
#
# OPENCV_CV_INCLUDE_DIR        location of cv.h
# OPENCV_CV_LIBRARY            location of cv library
# OPENCV_CXCORE_INCLUDE_DIR    location of cxcore.h
# OPENCV_CXCORE_LIBRARY        location of cxcore library
# OPENCV_CVAUX_INCLUDE_DIR     location of cvaux.h
# OPENCV_CVAUX_LIBRARY         location of cvaux library
# OPENCV_HIGHGUI_INCLUDE_DIR   location of highgui.h
# OPENCV_HIGHGUI_LIBRARY       location of highgui library

FIND_PATH(OPENCV_CV_INCLUDE_DIR cv.h
	${CMAKE_INCLUDE_PATH}
	${OPENCV1.0_PATH}/cv/include
)

FIND_PATH(OPENCV_CVAUX_INCLUDE_DIR cvaux.h
	${CMAKE_INCLUDE_PATH}
	${OPENCV1.0_PATH}/cvaux/include
)

FIND_PATH(OPENCV_CXCORE_INCLUDE_DIR cxcore.h
	${CMAKE_INCLUDE_PATH}
	${OPENCV1.0_PATH}/cxcore/include
)

FIND_PATH(OPENCV_HIGHGUI_INCLUDE_DIR highgui.h
	${CMAKE_INCLUDE_PATH}
	${OPENCV1.0_PATH}/otherlibs/highgui
)

FIND_LIBRARY(OPENCV_CV_LIBRARY
	NAMES
	cv210
	cv
	cv0.9.7
	cv200
	PATHS
	${CMAKE_LIBRARY_PATH}
	${OPENCV1.0_PATH}/lib
)

IF (OPENCV_CV_LIBRARY)
	SET(OPENCV_CV_FOUND TRUE)
ENDIF (OPENCV_CV_LIBRARY)

FIND_LIBRARY(OPENCV_CVAUX_LIBRARY
	NAMES
	cvaux210
	cvaux
	cvaux0.9.7
	cvaux200
	PATHS
	${CMAKE_LIBRARY_PATH}
	${OPENCV1.0_PATH}/lib
)

IF (OPENCV_CVAUX_LIBRARY)
	SET(OPENCV_CVAUX_FOUND TRUE)
ENDIF (OPENCV_CVAUX_LIBRARY)

FIND_LIBRARY(OPENCV_CXCORE_LIBRARY
	NAMES
	cxcore210
	cxcore
	cxcore0.9.7
	cxcore200
	PATHS
	${CMAKE_LIBRARY_PATH}
	${OPENCV1.0_PATH}/lib
)

IF (OPENCV_CXCORE_LIBRARY)
	SET(OPENCV_CXCORE_FOUND TRUE)
ENDIF (OPENCV_CXCORE_LIBRARY)

FIND_LIBRARY(OPENCV_HIGHGUI_LIBRARY
	NAMES
	highgui210
	highgui
	highgui0.9.7
	highgui200
	PATHS
	${CMAKE_LIBRARY_PATH}
	${OPENCV1.0_PATH}/lib
)

IF (OPENCV_HIGHGUI_LIBRARY)
	SET(OPENCV_HIGHGUI_FOUND TRUE)
ENDIF (OPENCV_HIGHGUI_LIBRARY)

SET(
	OPENCV_INCLUDES
	${OPENCV_CV_INCLUDE_DIR}
	${OPENCV_CVAUX_INCLUDE_DIR}
	${OPENCV_CXCORE_INCLUDE_DIR}
	${OPENCV_HIGHGUI_INCLUDE_DIR}
)

SET(
	OPENCV_LIBRARIES
	${OPENCV_CV_LIBRARY}
	${OPENCV_CVAUX_LIBRARY}
	${OPENCV_CXCORE_LIBRARY}
	${OPENCV_HIGHGUI_LIBRARY}
)

IF (OPENCV_CV_INCLUDE_DIR AND OPENCV_CVAUX_INCLUDE_DIR AND OPENCV_CV_LIBRARY AND OPENCV_CVAUX_LIBRARY)
	SET(OPENCV_FOUND TRUE)
ENDIF (OPENCV_CV_INCLUDE_DIR AND OPENCV_CVAUX_INCLUDE_DIR AND OPENCV_CV_LIBRARY AND OPENCV_CVAUX_LIBRARY)

MARK_AS_ADVANCED(
	OPENCV_FOUND
	OPENCV_INCLUDES
	OPENCV_LIBRARIES
	OPENCV_CV_INCLUDE_DIR
	OPENCV_CV_LIBRARY
	OPENCV_CXCORE_INCLUDE_DIR
	OPENCV_CXCORE_LIBRARY
	OPENCV_CVAUX_INCLUDE_DIR
	OPENCV_CVAUX_LIBRARY
	OPENCV_HIGHGUI_INCLUDE_DIR
	OPENCV_HIGHGUI_LIBRARY
) 


