# (C) 2009, Thorsten Roeder, <roeder@in.tum.de>


MACRO (MACRO_MY_APPLICATION)

MESSAGE(STATUS "---------------------------------------------------------")
MESSAGE(STATUS "Configuring:     ${MY_APPLICATION_NAME}")

SET(CMAKE_MODULE_PATH ${OPEN_TL_CMAKE_MODULE_PATH})

FIND_PACKAGE(OpenTL REQUIRED)
#FIND_PACKAGE(STOC)
#FIND_PACKAGE(RTDB)
FIND_PACKAGE(OpenTLBindings)
#FIND_PACKAGE(FFmpeg)
#FIND_PACKAGE(QuickTime)

IF (WIN32)
        # find CMU driver libraries
        FIND_PACKAGE(CMU1394)

        INCLUDE_DIRECTORIES(
                ${CMU1394_INCLUDES}
        )
ELSE (WIN32)
        IF (APPLE)
                # no apple specific camera support yet
        ELSE (APPLE)
                # Assume Linux and find libdc1394
                FIND_PACKAGE(libdc1394)
                FIND_PACKAGE(libraw1394)

                INCLUDE_DIRECTORIES(
                        ${LIBDC1394_INCLUDE_DIR}
                )
                ADD_DEFINITIONS(-DLIBDC1394_VERSION=${LIBDC1394_VERSION})
        ENDIF (APPLE)
ENDIF (WIN32)


SET(CMAKE_MODULE_PATH "${CMAKE_CURRENT_SOURCE_DIR}/../_cmake")
FIND_PACKAGE(CLEYE REQUIRED)
INCLUDE_DIRECTORIES(${CLEYE_INCLUDE_DIR})


ADD_EXECUTABLE(${MY_APPLICATION_NAME} ${SOURCE} ${HEADERS})

MESSAGE(STATUS "ADD_APPLICATION: ${MY_APPLICATION_NAME} >> ${SOURCE} >> ${HEADERS}")

IF(NOT STOC_FOUND)
SET(STOC_LIBRARIES "")
ELSE(NOT STOC_FOUND)
	INCLUDE_DIRECTORIES(${STOC_INCLUDES})
ENDIF(NOT STOC_FOUND)

IF(NOT FFMPEG_FOUND)
SET(FFMPEG_LIBRARIES "")
ELSE(NOT FFMPEG_FOUND)
	INCLUDE_DIRECTORIES(${FFMPEG_INCLUDE_DIRS})
ENDIF(NOT FFMPEG_FOUND)

IF(NOT QUICKTIME_FOUND)
SET(QUICKTIME_LIBRARIES "")
ELSE(NOT QUICKTIME_FOUND)
	INCLUDE_DIRECTORIES(${QUICKTIME_INCLUDES})
ENDIF(NOT QUICKTIME_FOUND)

IF(NOT RTDB_FOUND)
SET(RTDB_LIBRARY "")
ELSE(NOT RTDB_FOUND)
	INCLUDE_DIRECTORIES(${RTDB_INCLUDES_KOGMO})
	INCLUDE_DIRECTORIES(${RTDB_INCLUDES_OBJECTS})
ENDIF(NOT RTDB_FOUND)

IF (WIN32)
	SET(CAMERA_LIBRARIES ${CMU1394_LIBRARIES})
ELSE (WIN32)
	SET(CAMERA_LIBRARIES ${LIBDC1394_LIBRARY} ${LIBRAW1394_LIBRARY})
ENDIF (WIN32)

TARGET_LINK_LIBRARIES(
	${MY_APPLICATION_NAME}
	${OPENTL_MODULES}
	${OPENCV_LIBRARIES}
	${LIBGSL_LIBRARIES}
	${LIBGLEW_LIBRARIES}
	#${STOC_LIBRARIES}
	#${RTDB_LIBRARY}
	${IPP_LIBRARIES}
	${CAMERA_LIBRARIES}
	#${FFMPEG_LIBRARIES}
	#${QUICKTIME_LIBRARIES}
	${CLEYE_LIBRARY}
)

SET_TARGET_PROPERTIES("${MY_APPLICATION_NAME}" PROPERTIES DEBUG_POSTFIX "_d")

###SET_TARGET_PROPERTIES("${APP_NAME}" PROPERTIES VERSION ${APP_VERSION})
INSTALL(TARGETS "${MY_APPLICATION_NAME}"
	RUNTIME DESTINATION bin
	COMPONENT tutorials
)

MESSAGE(STATUS "---------------------------------------------------------")
ENDMACRO (MACRO_MY_APPLICATION)
