#region usings
using System;
using System.ComponentModel.Composition;

using System.IO;
using System.IO.Compression;
using ICSharpCode.SharpZipLib.Zip;

using VVVV.PluginInterfaces.V1;
using VVVV.PluginInterfaces.V2;
using VVVV.Utils.VColor;
using VVVV.Utils.VMath;

using VVVV.Core.Logging;
#endregion usings

namespace VVVV.Nodes
{
	#region PluginInfo
	[PluginInfo(Name = "Packer", Category = "String", Help = "Compresses a string and creates .zip archive", Tags = "string, gzip, compress")]
	#endregion PluginInfo
	public class StringPackNode : IPluginEvaluate
	{
		#region fields & pins
		
		[Input("Input Content", Order = 1)]
		IDiffSpread<string> FInput;
		
		[Input("Input FileName", DefaultString = "Slice00", Order = 2)]
		IDiffSpread<string> FPath;
		
		[Input("Output Filename", DefaultString = "v4.zip", IsSingle = true, Order = 3)]
		IDiffSpread<string> FArchive;
		
		[Input("Compression level", DefaultValue = 6, IsSingle = true, Order = 4)]
		IDiffSpread<int> FLevel;
		
		[Input("Update", IsBang = true, IsSingle = true, Order = 5)]
		ISpread<bool> FUpdate;
		
		[Output("Done", DefaultValue = 0, IsBang = true, IsSingle = true)]
		ISpread<bool> FReady;
		
		[Output("Output")]
		ISpread<string> FOutput;
		
		[Import()]
		ILogger FLogger;
		#endregion fields & pins

		private bool r = false;
		//called when data for any output pin is requested
		public void Evaluate(int SpreadMax)
		{
			if(FUpdate[0])
			{	
				if(FPath.SliceCount != FInput.SliceCount)
				{
					var j = FPath.SliceCount;
					FPath.SliceCount = FInput.SliceCount;
					for (var i = j; i<FInput.SliceCount; i++)
					{
						FPath[i] = "Slice" + i.ToString().PadLeft(FInput.SliceCount.ToString().Length + 1).Replace(' ','0');
					}
				}
				FOutput.AssignFrom(FPath);
				using (ZipOutputStream s = new ZipOutputStream(File.Create(FArchive[0]))) 
				{
					// 0 - store only to 9 - means best compression
					s.SetLevel(FLevel[0] > 9 ? 9 : FLevel[0]);
	
					for (int i = 0; i < FInput.SliceCount; i++)
					{
		
						byte[] buffer = System.Text.UTF8Encoding.ASCII.GetBytes(FInput[i]);
						
						ZipEntry entry = new ZipEntry(FPath[i]);
					
						entry.DateTime = DateTime.Now;
				
						s.PutNextEntry(entry);
				
						s.Write(buffer, 0, buffer.Length);
						
					} //for
					
					s.Finish();
					s.Close();
						
					r = true;
						
				} //using ZipOutputStream
				
			}
			
			FReady[0] = r;
			r = false;
		}
	}
}
