
float4x4 tW:WORLD;
float4x4 tV:VIEW;
float4x4 tWV: WORLDVIEW;
float4x4 tP:PROJECTION;
float4x4 tWVP:WORLDVIEWPROJECTION;
float Offset <float uimin=0.0; float uimax=1.0;> = 0;
float Angle <float uimin=-1.0; float uimax=1.0;> = 0;
float Deform <String uiname="Deformation"; float uimin=0.0; float uimax=1.0;> = 0.5;
float2 Scale <String uiname="Page Scale";> = {1.0, 1.5};
//float Direction;
bool Center <String uiname="Center to front page";> = false;
bool AvoidShadow <String uiname="Avoid shadow for opened pages"; float uimin=0.0;>;
float3 lDir <string uiname="Light Direction";> = {2, -1, 4};       //light direction in world space
float4 lAmb  : COLOR <String uiname="Ambient Color";>  = {0.15, 0.15, 0.15, 1};
float4 lDiff : COLOR <String uiname="Diffuse Color";>  = {0.85, 0.85, 0.85, 1};
float4 lSpec : COLOR <String uiname="Specular Color";> = {0.35, 0.35, 0.35, 1};
float sPower <String uiname="Shadow Power"; float uimin=0.0;> = 2.0;     //shininess of specular highlight
bool Reflection <String uiname="Do Reflection";> = false;
#define THICKNESS .0002
texture texA;// <string uiname="Texture Front";>;
texture texB;// <string uiname="Texture Back";>;
texture texENV;// <string uiname="Texture Reflection";>;
sampler sA=sampler_state{Texture=(texA);MipFilter=LINEAR;MinFilter=LINEAR;MagFilter=LINEAR;};
sampler sB=sampler_state{Texture=(texB);MipFilter=LINEAR;MinFilter=LINEAR;MagFilter=LINEAR;};
sampler sENV=sampler_state{Texture=(texENV);MipFilter=LINEAR;MinFilter=LINEAR;MagFilter=LINEAR;};
samplerCUBE ss=sampler_state{AddressU=MIRROR;AddressV=MIRROR;AddressW=MIRROR;Texture=(texENV);MipFilter=LINEAR;MinFilter=LINEAR;MagFilter=LINEAR;};

float3 r(float3 p,float3 z){z*=acos(-1)*2;float3 x=cos(z),y=sin(z);return mul(p,float3x3(x.y*x.z+y.x*y.y*y.z,-x.x*y.z,y.x*x.y*y.z-y.y*x.z,x.y*y.z-y.x*y.y*x.z,x.x*x.z,-y.y*y.z-y.x*x.y*x.z,x.x*y.y,y.x,x.x*x.y));}
//float3x3 tTex: TEXTUREMATRIX <string uiname="Texture Transform";>;
float3x3 tTexA: TEXTUREMATRIX <string uiname="Texture A Transform";>;
float3x3 tTexB: TEXTUREMATRIX <string uiname="Texture B Transform";>;

struct vs2ps
{
    float4 p  : POSITION0;
    float2 uv : TEXCOORD0;
    float3 n  : TEXCOORD1;
    float3 q  : TEXCOORD2;
};

vs2ps VSany(float4 pos:POSITION,float4 uv:TEXCOORD0,float Direction){
    vs2ps Out=(vs2ps)0;
    float3 p=pos;
    p=float3(sign(p.x)*THICKNESS,p.y,-abs(p.x)*2);
    float off=saturate(Offset);
    float of1=pow(saturate(.6-.4*length(p.yz+float2(Angle,1))),2);
    of1=lerp(pow(smoothstep(0,1,of1),pow(1-of1,8))*.2,of1,!!Angle*pow(saturate(2*abs(Angle)),3+Deform*2))*.3;
    float of2=pow(saturate(off*1.2-.2),2);
    float of3=sin(p.z*acos(-1)*1.5+lerp(2,-1,off))*.06*(2-abs(p.z))*sqrt(off);
    float ofc=of2+5*of1*pow(1-of2,1)*(saturate(off/.3))*.85+of3*pow(smoothstep(.5,0,abs(off-.5)),1);
    ofc=lerp(off,ofc,saturate(Deform));
    float3 n=float3(0,p.y*.1,1);
    n.z=n.z*sign(p.x);
    p.z*=1-off*.3*pow(saturate(Deform),2)*smoothstep(.5,0,abs(off-.5));
    p.zy*=lerp(Scale,Scale.yx,Direction==1||Direction==3);
    float3 rot=float3(0,0,0.25);
    p=r(p,float3(0,saturate(ofc)*.5-.25,0));
    n=r(n,float3(0,saturate(ofc+(ofc-off)*-.2-of3*(1+off)*sqrt(1-2*abs(off-.5)))*.5-.25,0));
    //p.z-=min(Offset-.2,0)*.01;
    //p.z+=max(Offset-1,0)*.01;
    n=n.zyx*float3(1,1,1);
    if(Direction==0){p.xy=p.xy-Center*float2(Scale.x*.5,0);}
    if(Direction==1){p.xy=p.yx*float2(1,-1)+Center*float2(0,Scale.y*.5);n.xy=n.yx*float2(1,-1);}
    if(Direction==2){p.xy=p.xy*float2(-1,1)+Center*float2(Scale.x*.5,0);n.xyz=n.xyz*float3(1,1,-1);}
    if(Direction==3){p.xy=p.yx*float2(-1,1)-Center*float2(0,Scale.y*.5);n.xy=n.yx*float2(-1,1);}
    if(Offset>3||Offset<-2)p=0;
    Out.q=p;
    Out.p=mul(float4(p,pos.w),tWVP);
    Out.uv=uv;
    Out.n=n;
   // Out.n=-normalize(mul(n,tWV));
    return Out;
}
vs2ps VSleft(float4 pos:POSITION,float4 uv:TEXCOORD0){return VSany(pos,uv,0);}
vs2ps VSup(float4 pos:POSITION,float4 uv:TEXCOORD0){return VSany(pos,uv,1);}
vs2ps VSright(float4 pos:POSITION,float4 uv:TEXCOORD0){return VSany(pos,uv,2);}
vs2ps VSdown(float4 pos:POSITION,float4 uv:TEXCOORD0){return VSany(pos,uv,3);}

float4 PSany(vs2ps In,float Direction):COLOR{
    float2 x=In.uv;
    float3 n=In.n;
    float4 c=1;
    float side=x.x>.5;
    float3x3 tTexAB=lerp(tTexA,tTexB,side);
    float2 uv=mul(float3(lerp(1-x.x*2,2-x.x*2,side)-.5,x.y-.5,1),tTexAB)+.5;
    if(Direction==1){uv=float2(1-uv.y,uv.x);}
    if(Direction==2){side=1-side;}
    if(Direction==3){uv=float2(uv.y,1-uv.x);}
    float4 cA=tex2D(sA,uv);
    float4 cB=tex2D(sB,uv);
    c=lerp(cA,cB,side);
    float3 light=pow(dot(normalize(n),normalize(lDir))*.5+.5,sPower);
    if(AvoidShadow)light=lerp(light,float3(1,1,1),!((x.x<.5&&Offset>.5)||(x.x>.5&&Offset<0.5))*pow(smoothstep(.3,.5,abs(saturate(Offset)-.5)),3));
    c.rgb*=saturate(lAmb+lDiff*light);
    c.rgb*=pow(smoothstep(.0,.1,abs(x.x-.5)),.1);
    //if(Reflection)c.rgb+=smoothstep(.0,.2,abs(x.x-.5))*pow(tex2D(sENV,(mul(n+x.y*.06+length(x)*.03,tWV)).xy),9)*lSpec;
    
	float3 ref=texCUBE(ss,mul(n+x.y*.06+length(x)*.03,tWV));//,8)*lSpec;
    //c.rgb+=smoothstep(.0,.2,abs(x.x-.5))*pow(texCUBE(ss,mul(n+x.y*.06+length(x)*.03,tWV)),8)*lSpec;
    c.rgb+=pow(smoothstep(.0,.2,abs(x.x-.5)),.25)*normalize(ref)*pow(length(ref)/sqrt(2),8)*lSpec;
	return c;
}
float4 PSleft(vs2ps In):COLOR{return PSany(In,0);}
float4 PSup(vs2ps In):COLOR{return PSany(In,1);}
float4 PSright(vs2ps In):COLOR{return PSany(In,2);}
float4 PSdown(vs2ps In):COLOR{return PSany(In,3);}

technique Left{pass P0{CullMode=CW;VertexShader=compile vs_3_0 VSleft();PixelShader=compile ps_3_0 PSleft();}}
technique Up{pass P0{CullMode=CW;VertexShader=compile vs_3_0 VSup();PixelShader=compile ps_3_0 PSup();}}
technique Right{pass P0{CullMode=CW;VertexShader=compile vs_3_0 VSright();PixelShader=compile ps_3_0 PSright();}}
technique Down{pass P0{CullMode=CW;VertexShader=compile vs_3_0 VSdown();PixelShader=compile ps_3_0 PSdown();}}
