#region usings
using System;
using System.Collections.Generic;
using System.ComponentModel.Composition;

using VVVV.PluginInterfaces.V1;
using VVVV.PluginInterfaces.V2;
using VVVV.Utils.VColor;
using VVVV.Utils.VMath;

using VVVV.Core.Logging;
#endregion usings

namespace VVVV.Nodes
{
	#region PluginInfo
	[PluginInfo(Name = "ParticleList", 
				Category = "3d", 
				Help = "Demonstrating how to deal with particles")]
	#endregion PluginInfo
	public class ParticleList : IPluginEvaluate
	{
		#region fields & pins
		[Input("Mouse")]
		ISpread<Vector3D> FMouse;
		
		[Input("Add", IsBang = true)]
		ISpread<bool> FAdd;

		[Output("Output")]
		ISpread<Vector3D> FOutput;
		
		[Input("ID")]
		ISpread<int> FID;
		
		[Input("Delete", IsBang = true)]
		ISpread<bool> FDelete;
		
		//the internal list of particles of custom type MyParticle
		//as defined below
		List<MyParticle> FParticles = new List<MyParticle>();
		#endregion fields & pins

		//called when data for any output pin is requested
		public void Evaluate(int SpreadMax)
		{
			//call the update function for all particles currently in the list
			foreach(var p in FParticles)
				p.Update();			
			
			//if the FAdd input is ON
			if (FAdd[0] == true)
			{
				//create a new particle at the given position with a random velocity vector
				var p = new MyParticle(FMouse[0], VMath.RandomVector3D() * 0.005);
				//and add that particle to the internal list
				FParticles.Add(p);
			}
			
			//if the FDelete input is ON and there is a particle ID 
			//remove it
			if (FID.SliceCount > 0 && FDelete[0])
				FParticles.RemoveAt(FID[0]);
			
			//in beta>24.1 you can directly assign lists to pins
			//FOuput.AssignFrom(FParticles);
			
			//in beta24.1 you still have to move the list entries
			//to the output slices manually
			FOutput.SliceCount = FParticles.Count;
			for (int i = 0; i < FParticles.Count; i++)
				FOutput[i] = FParticles[i].Position;
		}
	}

	//the custom type MyParticle
	//most simple kind of particle class
	//for real world usage better always descend from 
	//VVVV.Utils.Animation.Particle
	public class MyParticle
	{
		public Vector3D Position;
		Vector3D FDirection;
		
		public MyParticle(Vector3D initialPosition, Vector3D initialDirection)
		{
			Position = initialPosition;
			FDirection = initialDirection;
			FDirection.z = 0;
		}
		
		public void Update()
		{
			Position += FDirection;
		}
	}
}