
bool reset;
float3 gravity;
int pCount;

float velocityDamping = 0.95;

//Attractors Position Buffer
StructuredBuffer<float3> attrPos;
float attrToRadius = 1.0;
float attrStrength = 0.01;
float maxAttrMultiple = 1.2;

//RandomDirectionBuffer
StructuredBuffer<float3> rndDir;
int brwIndexShift;
float brwnStrenght;
float currentTime;
float timeDifference;

struct particle
{
	float3 pos;
	float3 vel;
	float4 col;
	float scale;
	float2 lifeFromTo;
	int index;
	float3 rotation;
};
RWStructuredBuffer<particle> Output : BACKBUFFER;

//==============================================================================
//COMPUTE SHADER ===============================================================
//==============================================================================

[numthreads(64, 1, 1)]
void CSConstantForce( uint3 DTid : SV_DispatchThreadID )
{
	if (reset)
	{
		Output[DTid.x].pos = 0;
		Output[DTid.x].vel = 0;
	}

	else
	{
		float3 p = Output[DTid.x].pos;
		float3 v = Output[DTid.x].vel;
		
		float timeMultiple =  timeDifference * 30.0;

		//Velocity Damping:
		v *= velocityDamping;
	
		//Attractor
		uint count,dummy;	
		// First get the same joint as it is created from
		attrPos.GetDimensions(count,dummy);
		float3 attrPosition = attrPos[Output[DTid.x].index % count];
		// attrPosition is the joint position, now make vector
		float3 attrDist = p - attrPosition;
		// if distance is <, *-1     if distance is >, add some max velocity
		attrDist *= max( length(attrDist) - attrToRadius , maxAttrMultiple);
		//if ( length(attrDist)<attrToRadius)
		v += attrStrength * attrDist;
		
		

		// Gravity
		v += gravity * timeMultiple;
		
		// Brownian
		uint rndIndex = DTid.x + brwIndexShift;
		rndIndex = rndIndex % pCount;
		float3 brwnForce = rndDir[rndIndex];
		v += brwnForce * brwnStrenght * timeMultiple;
		

		Output[DTid.x].vel = v;
		Output[DTid.x].pos = p + v * timeMultiple;
		
	}
}

//==============================================================================
//TECHNIQUES ===================================================================
//==============================================================================

technique11 simulation
{
	pass P0
	{
		SetComputeShader( CompileShader( cs_5_0, CSConstantForce() ) );
	}
}
