
bool reset;
float3 gravity;
int pCount;

//Ground:
float bounce = 1;

//Reset Position (xyz) and random damping (w)
StructuredBuffer<float4> resetData;

//ATTRACTORS:
float4x4 attrForceT;
//Attractors Position Buffer
StructuredBuffer<float3> attrPos;
//Attractors Data Buffer (X = radius, Y = Strength)
StructuredBuffer<float2> attrData;

//RandomDirectionBuffer
StructuredBuffer<float3> rndDir;
int brwIndexShift;
float brwnStrenght;
float currentTime;
float timeDifference;

struct particle
{
	float3 pos;
	float3 vel;
	float4 col;
	float scale;
	float2 lifeFromTo;
	int index;
	float3 rotation;
};
RWStructuredBuffer<particle> Output : BACKBUFFER;

//==============================================================================
//COMPUTE SHADER ===============================================================
//==============================================================================

[numthreads(64, 1, 1)]
void CSConstantForce( uint3 DTid : SV_DispatchThreadID )
{
	if (reset)
	{
		Output[DTid.x].pos = resetData[DTid.x].xyz;
		Output[DTid.x].vel = 0;
	}

	else
	{
		float3 p = Output[DTid.x].pos;
		float3 v = Output[DTid.x].vel;
		
		float timeMultiple =  timeDifference * 30.0;

		//Velocity Damping:
		//v *= pow(abs(resetData[DTid.x].w), timeMultiple);
		v *= resetData[DTid.x].w;
	
		//Multiple attractors
		uint count,dummy;	
		attrPos.GetDimensions(count,dummy);
		for(uint i=0 ; i<count; i++)
		{
			//attrVec = p - attrBuffer[i];
			float3 attrVec = attrPos[i] - p;
			float attrRadius = attrData[i].x;
			float attrStrength = attrData[i].y;

			float attrForce = length(attrVec) / attrRadius;
			attrForce = 1 - attrForce;
			attrForce = saturate(attrForce);
			attrForce = pow(attrForce, 2);
			attrVec = attrVec * attrForce * attrStrength;
			//transform attraction vector:
			attrVec = mul(float4(attrVec,1), attrForceT).xyz;
			v += attrVec;
		}

		// Brownian
		uint rndIndex = DTid.x + brwIndexShift;
		rndIndex = rndIndex % pCount;
		float3 brwnForce = rndDir[rndIndex];
		v += brwnForce * brwnStrenght * timeMultiple;
		
		//Ground:
		if(p.y < 0) 
		{
			v = reflect(v, float3(0,1,0));
		}
		//Bounce Smoother:
		//get the y space from 0 to 0.1 and use it attenuate gravity
		float bounceSmooth = saturate(p.y*10);  
		v += gravity * bounceSmooth * timeMultiple;

		Output[DTid.x].vel = v;
		Output[DTid.x].pos = p + v * timeMultiple;
		
		
		/*float lifeTo = Output[DTid.x].lifeFromTo.y;
		if (lifeTo < currentTime) {
			//Output[DTid.x].lifeFromTo.y = 2000;
			Output[DTid.x].pos = 1.0;
		}
		//Output[DTid.x].size = 2.0;*/
	}
}

//==============================================================================
//TECHNIQUES ===================================================================
//==============================================================================

technique11 simulation
{
	pass P0
	{
		SetComputeShader( CompileShader( cs_5_0, CSConstantForce() ) );
	}
}
