float4x4 tV: VIEW;         //view matrix as set via Renderer (EX9)
float4x4 tP: PROJECTION;   //projection matrix as set via Renderer (EX9)

float3 lDir <string uiname="Light Direction";> = {0, -5, 2}; 
float4 lAmb  : COLOR <String uiname="Ambient Color";>  = {0.15, 0.15, 0.15, 0};
float4 lDiff : COLOR <String uiname="Diffuse Color";>  = {0.85, 0.85, 0.85, 1};
float4 lSpec : COLOR <String uiname="Specular Color";> = {0.35, 0.35, 0.35, 1};
float lPower <String uiname="Power"; float uimin=0.0;> = 25.0;     
float lAlpha <String uiname="Alpha"; float uimin=0.0;> = 0.3;

float4 c <bool color=true;> = 1;
int currentTime = 0;

StructuredBuffer<float4x4> world;
struct particle
{
	float3 pos;
	float3 vel;
	float4 col;
	float size;
	float2 lifeFromTo;
	float3 rotation;
};
StructuredBuffer<particle> pData;

struct vs2ps
{
    float4 PosWVP: SV_POSITION;
    float4 TexCd: TEXCOORD0;
    float4 Diffuse: COLOR0;
    float4 Specular: COLOR1;
};

struct VS_IN
{
	uint ii : SV_InstanceID;
    float4 PosO  : POSITION;
    float3 NormO : NORMAL;
    float4 TexCd : TEXCOORD0;
};

vs2ps VS(VS_IN input)
{
    //inititalize all fields of output struct with 0
    vs2ps Out = (vs2ps)0;

    //inverse light direction in view space
    float3 LightDirV = normalize(-mul(float4(lDir,0), tV).xyz);
	
	//Here we need to modify the instance ID
	//float4x4 wv = mul(world[input.ii+ instanceOffset],tV);
	
	float2 time = pData[input.ii].lifeFromTo;

    //normal in view space
    //float3 NormV = normalize(mul(float4(input.NormO,0), wv).xyz);
    float3 NormV = normalize(mul(float4(input.NormO,0), tV).xyz);

	float4 PosW = float4(pData[input.ii].pos, .0);
	float lifeFrac = .5;
	if (time.x<time.y) {	// life from < life to, current time still can exceed
		lifeFrac = saturate( (currentTime-time.x) / (time.y-time.x) );	// life in 0..1
	}
	

	input.PosO.xyz *= pData[input.ii].size;
	input.PosO.xyz *= sqrt(lifeFrac);			// goes bigger by time
    float4 PosV = mul(input.PosO + PosW, tV);
    //view direction = inverse vertexposition in viewspace
    float3 ViewDirV = normalize(-PosV.xyz);

    //halfvector
    float3 H = normalize(ViewDirV + LightDirV);

    //compute blinn lighting
    float3 shades = lit(dot(NormV, LightDirV), dot(NormV, H), lPower).xyz;
    float4 diff = lDiff * shades.y;
    float4 spec = lSpec * shades.z;
    spec.a = 0;
    diff.a = 1-lifeFrac*lifeFrac;

    //position (projected)
    Out.PosWVP  = mul(PosV, tP);
    Out.TexCd = input.TexCd;
    Out.Diffuse = (diff + lAmb) * pData[input.ii].col;
    Out.Specular = spec;

    return Out;
}

float4 PS(vs2ps In): SV_Target
{
	//float4 col = In.Diffuse + float4(In.Specular.rgb,In.Specular.a*length(In.Specular.rgb));
    float4 col = In.Diffuse + In.Specular;
    //col.a = c.a;
    col *= c;
	col.rgb *= col.a;
	return col;
}

technique10 GouraudDirectional
{
	pass P0
	{
		SetGeometryShader( 0 );
		SetVertexShader( CompileShader( vs_4_0, VS() ) );
		SetPixelShader( CompileShader( ps_4_0, PS() ) );
	}
}

