//@author: vux
//@help: standard constant shader
//@tags: color
//@credits: 

float4x4 tV : VIEW;
float4x4 tVP : VIEWPROJECTION;
float4x4 tVI : VIEWINVERSE;
Texture2D texture2d;

float4 c <bool color=true;> = 1;
float velColMult = 1;

int currentTime = 0;

struct particle
{
	float3 pos;
	float3 vel;
	float4 col;
	float size;
	float2 lifeFromTo;
	float3 rotation;
};
StructuredBuffer<particle> pData;

float radius = 0.05f;
 
    float3 g_positions[4]:IMMUTABLE =
    {
        float3( -1, 1, 0 ),
        float3( 1, 1, 0 ),
        float3( -1, -1, 0 ),
        float3( 1, -1, 0 ),
    };
    float2 g_texcoords[4]:IMMUTABLE = 
    { 
        float2(0,1), 
        float2(1,1),
        float2(0,0),
        float2(1,0),
    };



SamplerState g_samLinear : IMMUTABLE
{
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = Clamp;
    AddressV = Clamp;
};

struct VS_IN
{
	uint iv : SV_VertexID;
};

struct vs2ps
{
    float4 PosWVP: SV_POSITION ;	
	float2 TexCd : TEXCOORD0 ;	
	float Size : TEXCOORD1 ;
	float4 Vcol : COLOR ;
};

vs2ps VS(VS_IN input)
{
    //inititalize all fields of output struct with 0
    vs2ps Out = (vs2ps)0;
	
	float3 p = pData[input.iv].pos;
	float3 v = pData[input.iv].vel;
	float4 c = pData[input.iv].col;
	float  s = pData[input.iv].size;
	
	float2 t = pData[input.iv].lifeFromTo;
	float lifeFrac = .5;
	if (t.x<t.y) {	// life from < life to
		lifeFrac = saturate( (currentTime-t.x) / (t.y-t.x) );	// life in 0..1
	}
	
    Out.PosWVP = float4(p,1);// mul(float4(po.xyz,1),tVP);
	Out.Vcol = c * float4(1,1,1, 1-lifeFrac*lifeFrac);	// disappearing by time
	Out.Size = s*2*lifeFrac;
	
    return Out;
}

vs2ps VS_vel(VS_IN input)
{
    //inititalize all fields of output struct with 0
    vs2ps Out = (vs2ps)0;
	
	float3 p = pData[input.iv].pos;
	float3 v = pData[input.iv].vel;
	float3 c = pData[input.iv].col.rgb;
	float  s = pData[input.iv].size;
	
    Out.PosWVP = float4(p,1);// mul(float4(po.xyz,1),tVP);
	Out.Vcol = float4(saturate(v * velColMult)+0.5,1);
	Out.Size = s;
	
    return Out;
}

[maxvertexcount(4)]
void GS(point vs2ps input[1], inout TriangleStream<vs2ps> SpriteStream)
{
    vs2ps output;
    
    //
    // Emit two new triangles
    //
    for(int i=0; i<4; i++)
    {
        float3 position = g_positions[i]*radius*input[0].Size;
        position = mul( position, (float3x3)tVI ) + input[0].PosWVP.xyz;
    	float3 norm = mul(float3(0,0,-1),(float3x3)tVI );
        output.PosWVP = mul( float4(position,1.0), tVP );
        
        output.TexCd = g_texcoords[i];	
        output.Vcol = input[0].Vcol;
        output.Size = input[0].Size;
    	
        SpriteStream.Append(output);
    }
    SpriteStream.RestartStrip();
}


float4 PS_Const(vs2ps In): SV_Target
{
    float4 col = c * In.Vcol * texture2d.Sample(g_samLinear,In.TexCd.xy);
	//if (col.r < 0.5f) { discard; }
	col.rgb *= col.a;	// force it to use the alpha chanel
    return col;
}

float4 PS_vCol(vs2ps In): SV_Target
{
    float4 col = In.Vcol;
	//if (col.r < 0.5f) { discard; }
    return col;
}

technique11 Constant
{
	pass P0
	{
		
		SetVertexShader( CompileShader( vs_5_0, VS() ) );
		SetGeometryShader( CompileShader( gs_5_0, GS() ) );
		SetPixelShader( CompileShader( ps_5_0, PS_Const() ) );
	}
}

technique11 VelocityColor
{
	pass P0
	{
		SetVertexShader( CompileShader( vs_5_0, VS_vel() ) );
		SetGeometryShader( CompileShader( gs_5_0, GS() ) );
		SetPixelShader( CompileShader( ps_5_0, PS_vCol() ) );
	}
}



