int pCount;
int emitCount;


//Emitters Position Buffer
StructuredBuffer<float3> emitSource;

//Emitters Color
StructuredBuffer<float4> emitCol;

StructuredBuffer<float3> emitRndDir;

int indexOffset;
int currentTime = 0;
int lifeTime = 100; // in 1/100 second



//Texture we want to read from
Texture2D tex <string uiname="Texture";>;

//Buffer containing uvs for sampling
//StructuredBuffer<float2> uv <string uiname="UV Buffer";>;

SamplerState mySampler : IMMUTABLE
{
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = Clamp;
    AddressV = Clamp;
};
//rwbuffer[i.x] = tex.SampleLevel(mySampler,uv[i.x],0);


struct particle
{
	float3 pos;
	float3 vel;
	float4 col;
	float scale;
	float2 lifeFromTo;
	int index;
	float3 rotation;
};

RWStructuredBuffer<particle> Output : BACKBUFFER;

//==============================================================================
//COMPUTE SHADER ===============================================================
//==============================================================================

[numthreads(1, 1, 1)]
void CSCloudEmiter( uint3 DTid : SV_DispatchThreadID )
{
	
	// Emitters Data:
	uint emitIndex = DTid.x % emitCount;
	// indices of emitted particles:
	uint index = indexOffset + DTid.x;
	index = index % pCount;
	
	
	//emitSource[emitIndex*2];
	float3 p = emitSource[emitIndex*2];
		// (3d) vector of new (3d)random position 	// (B-A)*(0..1)
	p += (emitSource[emitIndex*2+1] - emitSource[emitIndex*2]) * emitRndDir[index];
	float4 c = emitCol[emitIndex];
	
	// both position and color is derived from emitRndDir
	float4 textureColor = tex.SampleLevel(mySampler,emitRndDir[index].xz,0);

	// write position and velocity of emitted particles:
	Output[index].vel = 0;
	Output[index].pos = p;
	Output[index].col = c*textureColor;
	Output[index].scale = 2.0;
	Output[index].lifeFromTo.xy = float2( currentTime, currentTime + lifeTime);
	Output[index].index = index;
}

//==============================================================================
//TECHNIQUES ===================================================================
//==============================================================================

technique11 cloudEmission
{
	pass P0
	{
		SetComputeShader( CompileShader( cs_5_0, CSCloudEmiter() ) );
	}
}
