int pCount;
int emitCount;

//Emitters Position Buffer
StructuredBuffer<float3> emitPos;
//Emitters Color UV Coordinates
StructuredBuffer<float2> emitUVCoords;


StructuredBuffer<float3> emitRndDir;
float colorRandomness = 1;

int indexOffset;
int currentTime = 0;
int lifeTime = 100; // in 1/100 second


//Texture we want to read from
Texture2D tex <string uiname="Texture";>;

//Buffer containing uvs for sampling
//StructuredBuffer<float2> uv <string uiname="UV Buffer";>;

SamplerState mySampler : IMMUTABLE
{
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = Wrap;
    AddressV = Wrap;
};


struct particle
{
	float3 pos;
	float3 vel;
	float4 col;
	float scale;
	float2 lifeFromTo;
	int index;
	float3 rotation;
};

RWStructuredBuffer<particle> Output : BACKBUFFER;

//==============================================================================
//COMPUTE SHADER ===============================================================
//==============================================================================

[numthreads(1, 1, 1)]
void CSConstantForce( uint3 DTid : SV_DispatchThreadID )
{
	// Emitters Data:
	uint emitIndex = DTid.x % emitCount;
	//float3 p = emitPos[emitIndex];
	float3 v = 0;
	float4 c = 1;

	// indices of emitted particles:
	uint index = indexOffset + DTid.x;
	index = index % pCount;
	
	uint count,dummy;	
	emitPos.GetDimensions(count,dummy);
	float3 p = emitPos[index % count];

	// get color from texture
	emitUVCoords.GetDimensions(count,dummy);
	float4 textureColor = tex.SampleLevel(mySampler,emitUVCoords[index % count],0);
	
	// apply color from the texture:
	float4 rndCol = float4( lerp(1,emitRndDir[index]+.5,colorRandomness) , 1 );

	// write position and velocity of emitted particles:
	Output[index].vel = v;
	Output[index].pos = p + v*emitRndDir[index].r;
	Output[index].col = textureColor * textureColor * rndCol; 
	Output[index].scale = 1.0 + emitRndDir[index].r;
	Output[index].lifeFromTo.xy = float2( currentTime, currentTime + lifeTime);
	Output[index].index = index;
}

//==============================================================================
//TECHNIQUES ===================================================================
//==============================================================================

technique11 emissionPositionColored
{
	pass P0
	{
		SetComputeShader( CompileShader( cs_5_0, CSConstantForce() ) );
	}
}
