int pCount;
int emitCount;

//Emitters Position Buffer
StructuredBuffer<float3> emitPos;
//Emitters Data Buffer (XYZ emission velocity)
StructuredBuffer<float3> emitVel;
//Emitters Color
StructuredBuffer<float4> emitCol;

StructuredBuffer<float3> emitRndDir;
float rndEmitVelAmount;
float colorRandomness = 1;

int indexOffset;
int currentTime = 0;
int lifeTime = 100; // in 1/100 second

struct particle
{
	float3 pos;
	float3 vel;
	float4 col;
	float scale;
	float2 lifeFromTo;
	int index;
	float3 rotation;
};

RWStructuredBuffer<particle> Output : BACKBUFFER;

//==============================================================================
//COMPUTE SHADER ===============================================================
//==============================================================================

[numthreads(1, 1, 1)]
void CSConstantForce( uint3 DTid : SV_DispatchThreadID )
{
	// Emitters Data:
	uint emitIndex = DTid.x % emitCount;
	//float3 p = emitPos[emitIndex];
	float3 v = emitVel[emitIndex];
	float4 c = emitCol[emitIndex];

	// indices of emitted particles:
	uint index = indexOffset + DTid.x;
	index = index % pCount;
	
	uint count,dummy;	
	emitPos.GetDimensions(count,dummy);
	float3 p = emitPos[index % count];
	
	//random emission direction component:
	float3 rndEmitVel = rndEmitVelAmount * emitRndDir[index];
	rndEmitVel.xyz = 0;
	
	//single particle random color multiplier:
	float4 rndCol = float4( lerp(1,emitRndDir[index]+.5,colorRandomness) , 1 );

	// write position and velocity of emitted particles:
	Output[index].vel = v + rndEmitVel;
	Output[index].pos = p + v*emitRndDir[index].r;
	Output[index].col = c * rndCol; 
	Output[index].scale = 1.0 + emitRndDir[index].r;
	Output[index].lifeFromTo.xy = float2( currentTime, currentTime + lifeTime);
	Output[index].index = index;
}

//==============================================================================
//TECHNIQUES ===================================================================
//==============================================================================

technique11 emissionPositionRandomized
{
	pass P0
	{
		SetComputeShader( CompileShader( cs_5_0, CSConstantForce() ) );
	}
}
