int pCount;
int emitCount;


//Emitters Position Buffer
StructuredBuffer<float3> emitSource;

//Emitters Color
StructuredBuffer<float4> emitCol;

StructuredBuffer<float3> emitRndDir;

int indexOffset;
int currentTime = 0;
int lifeTime = 100; // in 1/100 second

struct particle
{
	float3 pos;
	float3 vel;
	float4 col;
	float scale;
	float2 lifeFromTo;
	int index;
	float3 rotation;
};

RWStructuredBuffer<particle> Output : BACKBUFFER;

//==============================================================================
//COMPUTE SHADER ===============================================================
//==============================================================================

[numthreads(1, 1, 1)]
void CSCloudEmiter( uint3 DTid : SV_DispatchThreadID )
{
	
	// Emitters Data:
	uint emitIndex = DTid.x % emitCount;
	// indices of emitted particles:
	uint index = indexOffset + DTid.x;
	index = index % pCount;
	
	
	emitSource[emitIndex*2];
	float3 p = emitSource[emitIndex*2];
		// (3d) vector of new (3d)random position
	//p += (emitSource[emitIndex*2+1] - emitSource[emitIndex*2]) * emitRndDir[index];

	// mathematical function to create uniform random distribution on a sphere
	float theta0 = 2 * 3.14159265 * emitRndDir[index].x;
	float theta1 = acos( 1 - 2*emitRndDir[index].y );
	float3 SpherePos;
	SpherePos.x = cos(theta0)*sin(theta1);
	SpherePos.y = sin(theta0)*sin(theta1);
	SpherePos.z = cos(theta1);
	
	// get radius from From To input 	// F + (T-F)*(0..1)
	float radiusMultiple = emitSource[emitIndex*2+1].x + (emitSource[emitIndex*2+1].y-emitSource[emitIndex*2+1].x)*emitRndDir[index].z;
	p += SpherePos * radiusMultiple;
	
	float4 c = emitCol[emitIndex];

	// write position and velocity of emitted particles:
	Output[index].vel = SpherePos * emitSource[emitIndex*2+1].z;
	Output[index].pos = p;
	Output[index].col = c;
	Output[index].scale = 1.0;
	Output[index].lifeFromTo.xy = float2( currentTime, currentTime + lifeTime);
	Output[index].index = index;
}

//==============================================================================
//TECHNIQUES ===================================================================
//==============================================================================

technique11 cloudEmission
{
	pass P0
	{
		SetComputeShader( CompileShader( cs_5_0, CSCloudEmiter() ) );
	}
}
