#region usings
using System;
using System.ComponentModel.Composition;
using System.Collections.Generic;

using VVVV.PluginInterfaces.V1;
using VVVV.PluginInterfaces.V2;
using VVVV.Utils.VColor;
using VVVV.Utils.VMath;

using VVVV.Core.Logging;
#endregion usings

namespace VVVV.Nodes
{
	#region PluginInfo
	[PluginInfo(Name = "PathVectors", Category = "3d", Help = "calculates points along a spline's path", Tags = "", Author = "herbst")]
	#endregion PluginInfo
	public class PathVectorsNode : IPluginEvaluate
	{
		#region fields & pins
		[Input("HelperPoints")]
		public ISpread<ISpread<Vector3D>> FHelperPoints;

		[Input("Input")]
		public ISpread<ISpread<double>> FInput;

		[Input("Closed")]
		public ISpread<bool> FClosed;

		[Output("OutputPoints")]
		public ISpread<Vector3D> FOutputPoints;

		[Output("OutputSlice")]
		public ISpread<double> FOutputSlice;
		
		[Output("Length")]
		public ISpread<double> FLength;
		
		//[Import()]
		//public ILogger FLogger;
		#endregion fields & pins

		
		double[][] lengths;
		public void Evaluate(int SpreadMax)
		{		
			FOutputPoints.SliceCount = 0;
			FOutputSlice.SliceCount = 0;
			FLength.SliceCount = 0;
			
			int count = 0;
			for(int i = 0; i < FInput.SliceCount; i++)
				count += FInput[i].SliceCount;
			
			SpreadMax = Math.Max(FHelperPoints.SliceCount, FInput.SliceCount);
			
			if(lengths == null || lengths.Length != FHelperPoints.SliceCount)
				lengths = new double[FHelperPoints.SliceCount][];
			
			for(int i = 0; i < FHelperPoints.SliceCount; i++)
			{
				lengths[i] = PreCalc(i);
			}
			
			int k = 0;
			for(int i = 0; i < SpreadMax; i++) {
				for(int j = 0; j < FInput[i].SliceCount; j++) {
					Calc(lengths[i % lengths.Length], i, k++);
				}
			}
		}
		
		double[] PreCalc(int index)
		{
			bool closed = FClosed[index];
			ISpread<Vector3D> helpers = FHelperPoints[index];
			
			double[] lengths_;
			if(lengths[index] == null || lengths[index].Length != helpers.SliceCount + (closed ? 1 : 0))
				lengths_ = new double[helpers.SliceCount + (closed ? 1 : 0)];
			else
				lengths_ = lengths[index];
			
			if(helpers.SliceCount < 2)
				return lengths_;
			
			double length = 0;
			for(int i = 0; i < helpers.SliceCount - (closed ? 0 : 1); i++)
			{
				lengths_[i] = length;
				length += (helpers[i+1] - helpers[i]).Length;
			}
			lengths_[lengths_.Length - 1] = length;
			FLength.Add(length);
			
			return lengths_;
		}
		
		void Calc(double[] lengths, int helperIndex, int index)
		{
			ISpread<Vector3D> helpers = FHelperPoints[helperIndex];
			
			ISpread<double> values = FInput[helperIndex];
			double totalLength = FLength[helperIndex];
			
			int i = index;
			double j = FindIndex(lengths, values[i] * totalLength);
			FOutputSlice.Add(j);
			FOutputPoints.Add(GetPoint(helpers, j));
		}
		
		double FindIndex(double[] lengths, double value)
		{
			if(lengths.Length < 2) return 0;
			
			int k = 0;
			while(k < lengths.Length - 1)
			{
				k++;
				if(value < lengths[k])
					break;
			}
			
			double index = (k-1) + (value - lengths[k-1])/(lengths[k] - lengths[k-1]);
			return index;
		}
		
		Vector3D GetPoint(ISpread<Vector3D> helpers, double index)
		{
			int i = (int)Math.Floor(index);
			double frac = index - i;
			return helpers[i] + (helpers[i+1] - helpers[i]) * frac;
		}
	}
}
