#region usings
using System;
using System.ComponentModel.Composition;

using VVVV.PluginInterfaces.V1;
using VVVV.PluginInterfaces.V2;
using VVVV.Utils.VColor;
using VVVV.Utils.VMath;

using VVVV.Core.Logging;
#endregion usings

namespace VVVV.Nodes
{
	#region PluginInfo
	[PluginInfo(Name = "Heart", Category = "2d", Author = "fibo", Help = "Plane curve", Tags = "2d,curve")]
	#endregion PluginInfo
	public class C2dHeartNode : IPluginEvaluate
	{
	#region fields & pins
		[Input("Input A", DefaultValue = 0.9)]
		ISpread<double> FInputA;

		[Input("Input B", DefaultValue = 1.0)]
		ISpread<double> FInputB;

		[Input("Time", DefaultValue = 0)]
		ISpread<double> FInputT;

		[Output("Output X")]
		ISpread<double> FOutputX;

		[Output("Output Y")]
		ISpread<double> FOutputY;

		[Import()]
		ILogger Flogger;
		#endregion fields & pins

		//called when data for any output pin is requested
		public void Evaluate(int SpreadMax)
		{
			FOutputX.SliceCount = SpreadMax;
			FOutputY.SliceCount = SpreadMax;

			for (int i = 0; i < SpreadMax; i++) {
				FOutputX[i] = FInputA[i] * ( 16 * Math.Sin(FInputT[i]) * Math.Sin(FInputT[i]) * Math.Sin(FInputT[i]) );
				FOutputY[i] = FInputB[i] * ( 13 * Math.Cos(FInputT[i]) - 5 * Math.Cos(2 * FInputT[i]) - 2 * Math.Cos(3 * FInputT[i]) - Math.Cos(4 * FInputT[i]) );
			}

			//Flogger.Log(LogType.Debug, "Logging to Renderer (TTY)");
		}
	}
}
