//@author: antokhio
//@help: template
//@tags: template
//@credits: vvvv
#include "..\common\PE_Vertex.fxh"

float4x4 tVP;

float2 center;
float2 size;


bool TagAdd;
bool TagRemove;
//bool TagInvert;

bool SelectAll<bool bang = true;>;
bool DeselectAll <bool bang = true;>;

RWStructuredBuffer<Vertex> Output : BACKBUFFER;

bool InRect (float2 x, float2 c, float2 s)
{
	if (abs(c.x - x.x) < s.x/2 && abs(c.y - x.y) < s.y/2 )
	return true;
	else
	return false;
}

[numthreads(32, 1, 1)]
void CS_CREATEBUFFER( uint3 DTid : SV_DispatchThreadID )
{
	if (TagAdd)
	{
		float4 pos = mul (float4 (Output[DTid.x].pos,1),tVP);
		pos.xyz/=pos.w;
		if (InRect(pos.xy, center, size))
			Output[DTid.x].tag = 1;
	}
	if (TagRemove)
	{
		float4 pos = mul (float4 (Output[DTid.x].pos,1),tVP);
		pos.xyz/=pos.w;
		if (InRect(pos.xy, center, size))
			Output[DTid.x].tag = 0;
	}
/*	if (TagInvert)
	{
		float4 pos = mul (float4 (Output[DTid.x].pos,1),tVP);
		pos.xyz/=pos.w;
		if (InRect(pos.xy, center, size))
		{
			if (Output[DTid.x].tag)
				Output[DTid.x].tag = 0;
			else
				Output[DTid.x].tag = 1;
		}					
	}
*/
/*	if (Tag)
	{
		float4 pos = mul (float4 (Output[DTid.x].pos,1),tVP);
		pos.xyz/=pos.w;
		if (InRect(pos.xy, center, size))
		Output[DTid.x].tag = 1;
		else
		Output[DTid.x].tag = 0;
	}
*/	
	if (SelectAll)
		Output[DTid.x].tag = 1;
	if (DeselectAll)
		Output[DTid.x].tag = 0;
	
}
technique11 PE_TegSelectClear
{
	pass P0
	{
		SetComputeShader( CompileShader( cs_5_0, CS_CREATEBUFFER() ) );
	}
}
