//@author: antokhio 
//@help: template
//@tags: template 
//@credits: vvvv
#include "..\common\PE_Vertex.fxh"

float3 Offset;

RWStructuredBuffer<Vertex> Output : BACKBUFFER;

uint COUNT : TOTALCOUNT;

bool Normal;

float3x3 lookat(float3 dir,float3 up=float3(0,1,0)){float3 z=normalize(dir);float3 x=normalize(cross(up,z));float3 y=normalize(cross(z,x));return float3x3(x,y,z);}

[numthreads(32, 1, 1)]
void CS_CREATEBUFFER( uint3 DTid : SV_DispatchThreadID )
{	
	
	if (Output[DTid.x].tag && !Normal)
		Output[DTid.x].pos += Offset;
	if (Output[DTid.x].tag && Normal)
		Output[DTid.x].pos += mul (Offset, lookat(Output[DTid.x].normal));
}

technique11 PE_Process
{
	pass P0
	{
		SetComputeShader( CompileShader( cs_5_0, CS_CREATEBUFFER() ) );
	}
}
