//@author: antokhio 
//@help: template
//@tags: template 
//@credits: vvvv

#include "..\..\common\PE_Vertex.fxh"
StructuredBuffer<Vertex> pBuffer <string uiname="Vertex Buffer";>;

float4x4 tW : WORLD;
float4x4 tVP : VIEWPROJECTION;

float4 g_pos[6] : IMMUTABLE =
{
	{0,0,0,1},{1,0,0,1},
	{0,0,0,1},{0,1,0,1},
	{0,0,0,1},{0,0,1,1}
};
float4 g_col[6] : IMMUTABLE = 
{
	{1,0,0,1},{1,0,0,1},
	{0,1,0,1},{0,1,0,1},
	{0,0,1,1},{0,0,1,1}
};

StructuredBuffer<float> sbAxis;
bool Normal;
struct VS_IN
{
	uint iv : SV_VertexID;
	uint ii : SV_InstanceID;
};

struct VS_OUT
{
    float4 pos: POSITION;
	float4 col : COLOR;
	bool tag : TEXCOORD0;
};
struct GS_OUT
{
	float4 pos : SV_Position;
	float4 col : COLOR;
};

float3x3 lookat(float3 dir,float3 up=float3(0,1,0)){float3 z=normalize(dir);float3 x=normalize(cross(up,z));float3 y=normalize(cross(z,x));return float3x3(x,y,z);}

VS_OUT VS(VS_IN input)
{
    VS_OUT output = (VS_OUT)0;	

	//float4 pos = mul (g_pos[input.iv], tW);
	float4 pos = g_pos[input.iv];
	if (Normal)
		pos.xyz = mul ( pos.xyz, lookat(pBuffer[input.ii].normal));
	
	pos = mul (pos,tW);
	pos.xyz += pBuffer[input.ii].pos;
	
		
	output.pos = mul (pos, tVP);
	output.col = g_col[input.iv] + sbAxis[input.iv];
    output.tag = pBuffer[input.ii].tag;
	return output;
}

[maxvertexcount(2)]
void GS(line VS_OUT input[2], inout LineStream<GS_OUT> lines)
{
	GS_OUT output;
	if 	(input[0].tag)
	{
		for (int i = 0; i < 2 ;  i++) 
		{
			output.pos = input[i].pos;
			output.col = input[i].col;
			lines.Append(output);
		};

		lines.RestartStrip();
	}
}


float4 PS(GS_OUT input): SV_Target
{
    return input.col;
}

technique10 Template
{
	pass P0
	{
		SetVertexShader( CompileShader( vs_5_0, VS() ) );
		SetGeometryShader( CompileShader( gs_5_0, GS() ) );
		SetPixelShader( CompileShader( ps_4_0, PS() ) );
		
	}
}




