//@author: antokhio 
//@help: Sprite layer
//@tags: sprite 
//@credits: antokhio
#include "..\..\common\PE_Vertex.fxh"

StructuredBuffer<Vertex> pBuffer <string uiname="Vertex Position Buffer";>;

float4x4 tW : WORLD;
float4x4 tVP : VIEWPROJECTION;
float4x4 tV : VIEW;
float4x4 tP : PROJECTION;

struct VS_IN
{
	float4 pos : POSITION;
	uint iv : SV_InstanceID;
};

struct VS_OUT
{
    float4 pos: SV_POSITION;
	float4 col: COLOR;
};

VS_OUT VS(VS_IN input)
{
    VS_OUT output;

	float4 pos = float4 (pBuffer[input.iv].pos, 1);
	pos = mul (pos, tVP);
	output.pos  = float4 (pos.xyz + mul (input.pos, tW).xyz, pos.w);
	output.col = lerp (float4 (1,1,1,1), float4 (1,0,0,1),pBuffer[input.iv].tag);
    return output;
}

float4 PS(VS_OUT input): SV_Target
{
	float4 col = input.col;
    return col;
}

technique10 PE_Sprite
{
	pass P0
	{
		SetVertexShader( CompileShader( vs_4_0, VS() ) );
		SetPixelShader( CompileShader( ps_4_0, PS() ) );
	}
}




