#region usings
using System;
using System.ComponentModel.Composition;

using VVVV.PluginInterfaces.V1;
using VVVV.PluginInterfaces.V2;
using VVVV.Utils.VColor;
using VVVV.Utils.VMath;

using PrintPict;

using VVVV.Core.Logging;
#endregion usings

namespace VVVV.Nodes
{
	#region PluginInfo
	[PluginInfo(Name = "PrintPicture", Category = "Boolean", Help = "PrintPictures", Tags = "", AutoEvaluate = true)]
	#endregion PluginInfo
	public class BooleanPrintPictureNode : IPluginEvaluate
	{
		#region fields & pins
		[Input("Filename", StringType = StringType.Filename, IsSingle = true)]
		public ISpread<string> myfile;
		
		[Input("Position2D")]
		public ISpread<int> Pos;
		
		[Input("Size2D")]
		public ISpread<int> Size;
		
		[Input("Print", IsBang = true, IsSingle = true)]
		public ISpread<bool> FInput;
		
		[Import()]
		public ILogger FLogger;
		#endregion fields & pins

		//called when data for any output pin is requested
		public void Evaluate(int SpreadMax)
		{
			int H = Pos[0];
			int V = Pos[1];
			int W = Size[0];
			int T = Size[1];
			
			if(FInput[0])
			{
				PrintPict.PrintClass.PrintDoc(myfile[0], H , V, W, T );
				//PrintPict.PrintClass.PrintDoc(myfile[0],100,100,100,100);
			}

			//FLogger.Log(LogType.Debug, "hi TTY");
		}
	}
}
