//@author: antokhio
//@help: 2d quad line with adjacency
//@tags: line
//@credits: Paul Houx
//https://github.com/paulhoux/Cinder-Samples/tree/master/GeometryShader

cbuffer cbPerDraw : register( b0 )
{
	float4x4 tWVP: WORLDVIEWPROJECTION;
};

cbuffer cbPerObj : register( b1 )
{
	float Thickness = 0.1f;
	float MITER_LIMIT = 0.75f;
	int IntanceStartIndex;
	float4 cAmb <bool color=true;String uiname="Color";> = { 1.0f,1.0f,1.0f,1.0f };
	float Alpha <float uimin=0.0; float uimax=1.0;> = 1; 
};

StructuredBuffer<float2> lineBuffer;

struct VS_IN
{
	uint iv : SV_VertexID;
	uint ii : SV_InstanceID;
};

struct VS_OUTPUT
{
    float2 pos : POSITION;
};

struct GS_OUTPUT
{
    float4 pos : SV_POSITION;
};

VS_OUTPUT VS(VS_IN input)
{
	VS_OUTPUT p = (VS_OUTPUT)0;
	p.pos = lineBuffer[input.iv + IntanceStartIndex].xy;
    return p;
}

[maxvertexcount(4)]
void GS(lineadj VS_OUTPUT input[4], inout TriangleStream<GS_OUTPUT> gsout)
{
	GS_OUTPUT output;
	
	float2 p0 = input[0].pos;
	float2 p1 = input[1].pos;
	float2 p2 = input[2].pos;
	float2 p3 = input[3].pos;
	
	
// determine the direction of each of the 3 segments (previous, current, next)
	float2 v0 = normalize(p1-p0);
	float2 v1 = normalize(p2-p1);
	float2 v2 = normalize(p3-p2);
	
	float2 n0 = float2(-v0.y, v0.x);
	float2 n1 = float2(-v1.y, v1.x);
	float2 n2 = float2(-v2.y, v2.x);
	 // determine miter lines by averaging the normals of the 2 segments
  float2 miter_a = normalize(n0 + n1);	// miter at start of current segment
  float2 miter_b = normalize(n1 + n2);	// miter at end of current segment

  // determine the length of the miter by projecting it onto normal and then inverse it
  float length_a = Thickness / dot(miter_a, n1);
  float length_b = Thickness / dot(miter_b, n1);
 // prevent excessively long miters at sharp corners
  if( dot(v0,v1) < -MITER_LIMIT ) {
	miter_a = n1;
	length_a = Thickness;
	
	// close the gap
	if( dot(v0,n1) > 0 ) {
		output.pos = float4 ((p1 + Thickness * n0), 0.0, 1.0 );
		output.pos = mul (output.pos,tWVP);
		gsout.Append(output);
		output.pos = float4 ((p1 + Thickness * n1), 0.0, 1.0 );
		output.pos = mul (output.pos,tWVP);
		gsout.Append(output);
		output.pos = float4 (p1, 0.0, 1.0 );
		output.pos = mul (output.pos,tWVP);
		gsout.Append(output);
		gsout.RestartStrip();	

	}
	else {
		output.pos = float4 ((p1 - Thickness * n1), 0.0, 1.0 );
		output.pos = mul (output.pos,tWVP);
		gsout.Append(output);
		output.pos = float4 ((p1 - Thickness * n0), 0.0, 1.0 );
		output.pos = mul (output.pos,tWVP);
		gsout.Append(output);
		output.pos = float4 ((p1), 0.0, 1.0 );
		output.pos = mul (output.pos,tWVP);
		gsout.Append(output);
		gsout.RestartStrip();	
	}
  }

  if( dot(v1,v2) < -MITER_LIMIT ) {
	miter_b = n1;
	length_b = Thickness;
  }
  // generate the triangle strip
	output.pos = float4 ((p1 + length_a * miter_a), 0.0, 1.0 );
	output.pos = mul (output.pos,tWVP);
	gsout.Append(output);
	output.pos = float4 ((p1 - length_a * miter_a), 0.0, 1.0 );
	output.pos = mul (output.pos,tWVP);
	gsout.Append(output);
	output.pos = float4 ((p2 + length_b * miter_b), 0.0, 1.0 );
	output.pos = mul (output.pos,tWVP);
	gsout.Append(output);
	output.pos = float4 ((p2 - length_b * miter_b), 0.0, 1.0 );
	output.pos = mul (output.pos,tWVP);
	gsout.Append(output);
	gsout.RestartStrip();	
		
}

float4 PS(GS_OUTPUT input) : SV_Target
{   
	float4 col = cAmb;
	col.a *= Alpha;
	return col;
}


technique11 Constant
{
	pass P0
	{

		SetVertexShader( CompileShader( vs_5_0, VS() ) );
		SetGeometryShader(CompileShader(gs_4_0,GS()));
		SetPixelShader( CompileShader( ps_5_0, PS() ) );
	}
}



