#region usings
using System;
using System.ComponentModel.Composition;

using VVVV.PluginInterfaces.V1;
using VVVV.PluginInterfaces.V2;
using VVVV.Utils.VColor;
using VVVV.Utils.VMath;

using VVVV.Core.Logging;
#endregion usings

namespace VVVV.Nodes
{
	#region PluginInfo
	[PluginInfo(Name = "ScaleToMouse", Category = "Transform", Help = "Scale Objects relative to mouse position", Tags = "matrix")]
	#endregion PluginInfo
	public class TransformScaleToMouseNode : IPluginEvaluate
	{
		#region fields & pins
		
		bool firstFrame = true;
		ISpread<Matrix4x4> temp;
		
		[Input("Input")]
		ISpread<Matrix4x4> FInput;
		
		[Input("X")]
		ISpread<double> FX;
		[Input("Y")]
		ISpread<double> FY;
		
		[Input("ScaleFactor")]
		ISpread<double> FScaleFactor;
		
		[Input("Initialzie")]
		ISpread<bool> FInit;
		
		[Input("ScaleUp")]
		ISpread<bool> FScaleUp;
		
		[Input("ScaleMin")]
		ISpread<double> FScaleMin;
		
		[Input("ScaleMax")]
		ISpread<double> FScaleMax;
		
		[Input("ScaleDown")]
		ISpread<bool> FScaleDown;
		
		[Output("Output")]
		ISpread<Matrix4x4> FOutput;

		[Import()]
		ILogger FLogger;
		#endregion fields & pins

		//called when data for any output pin is requested
		public void Evaluate(int SpreadMax)
		{
			FOutput.SliceCount = SpreadMax;
			if(firstFrame){
			for (int i = 0; i < SpreadMax; i++){
					
					FOutput[i] = FInput[i];
				
				}
				temp = FInput;
				firstFrame=false;
			}
			
			if(FScaleDown[0] || FScaleUp[0]){
				for (int i = 0; i < SpreadMax; i++){
					FInput[i] = FInput[i] * VMath.Translate(-FX[i], -FY[i], 0);
					if (FScaleDown[i] && FOutput[i].m33 > FScaleMin[i])
					FInput[i] = FInput[i] * VMath.Scale(1-FScaleFactor[i], 1-FScaleFactor[i], 1-FScaleFactor[i]);
					if (FScaleUp[i] && FOutput[i].m33 < FScaleMax[i])
					FInput[i] = FInput[i] * VMath.Scale(1/(1-FScaleFactor[i]), 1/(1-FScaleFactor[i]), 1/(1-FScaleFactor[i]));
					FInput[i] = FInput[i] * VMath.Translate(FX[i], FY[i], 0);
					FOutput[i] = FInput[i];
				}
			}
			
		
			if (FInit[0]){
				for (int i = 0; i < SpreadMax; i++){
					FInput[i] = VMath.Scale(1,1,1);
					FInput[i] = VMath.Translate(0,0,0);
					FOutput[i] = FInput[i];
					}
					
				}
			
			
		}
		
		
		
		
	}
	
}

