//@author: umanema
//@help: a skybox implementation of a shader from shadertoy
//@tags: skybox, raymarching, shadertoy
//@credits: Kali
//@license: Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.

static const int Iterations=14;
static const float detail=.00002;
static const float Scale=2.;

float3 lightdir=normalize(float3(0.,-0.3,-1.));

//float ot=0.;
//float det=0.;

//float hitfloor;
//float hitrock;

cbuffer cbControls:register(b0){
	float4x4 tW:WORLD;
	float4x4 tV:VIEW;
	float4x4 tP:PROJECTION;
	float4x4 tVI:VIEWINVERSE;
	float4x4 tPI:PROJECTIONINVERSE;
	float4x4 tWIT:WORLDINVERSETRANSPOSE;
	
	float iTime = 0.0;
	
};

struct VS_IN{
	float4 PosO:POSITION;
	float4 TexCd:TEXCOORD0;
};

struct VS_OUT{
	float4 PosWVP:SV_POSITION;
	float4 TexCd:TEXCOORD0;
	float4 PosW:TEXCOORD1;
};

VS_OUT VS(VS_IN In){
	VS_OUT Out=(VS_OUT)0;
	float4 PosW=In.PosO;
	PosW=mul(PosW,tW);
	Out.TexCd=In.TexCd;
	Out.PosW=PosW;
	Out.PosWVP=mul(PosW,mul(tV,tP));
	return Out;
}

float smin( float a, float b, float k )
{
    float h = clamp( 0.5+0.5*(b-a)/k, 0.0, 1.0 );
    return lerp( b, a, h ) - k*h*(1.0-h);
}

float de(float3 pos, float3 shift, float tt) {
	
	float3 p=pos;
	p.xz=abs(.5-fmod(pos.xz,1.))+.01;
	float DEfactor=1.;
	float ot=1000.;
	for (int i=0; i<Iterations; i++) {
		p = abs(p)-float3(0.,2.,0.);  
		float r2 = dot(p, p);
		float sc=Scale/clamp(r2,0.4,1.);
		p*=sc; 
		DEfactor*=sc;
		p = p - float3(0.5,1.,0.5);
	}
	
    float rr=length(pos+float3(-shift.x,-3.03,1.85-tt))-.017;
    float fl=pos.y-3.013;
    float d=min(fl,length(p)/DEfactor-.0005);
	d=min(d,-pos.y+3.9);
    d=min(d,rr);
    return d;
}

float getHitFloor(float3 pos, float3 shift, float tt) {
	float hitfloor=0.;
	float3 p=pos;
	p.xz=abs(.5-fmod(pos.xz,1.))+.01;
	float DEfactor=1.;
	float ot=1000.;
	for (int i=0; i<Iterations; i++) {
		p = abs(p)-float3(0.,2.,0.);  
		float r2 = dot(p, p);
		float sc=Scale/clamp(r2,0.4,1.);
		p*=sc; 
		DEfactor*=sc;
		p = p - float3(0.5,1.,0.5);
	}
	
    float rr=length(pos+float3(-shift.x,-3.03,1.85-tt))-.017;
    float fl=pos.y-3.013;
    float d=min(fl,length(p)/DEfactor-.0005);
	d=min(d,-pos.y+3.9);
    d=min(d,rr);
	if (abs(d-fl)<.0001) hitfloor=1.;
	return hitfloor;
}

float getHitRock(float3 pos, float3 shift, float tt){
	float hitrock=0.;
	float3 p=pos;
	p.xz=abs(.5-fmod(pos.xz,1.))+.01;
	float DEfactor=1.;
	float ot=1000.;
	for (int i=0; i<Iterations; i++) {
		p = abs(p)-float3(0.,2.,0.);  
		float r2 = dot(p, p);
		float sc=Scale/clamp(r2,0.4,1.);
		p*=sc; 
		DEfactor*=sc;
		p = p - float3(0.5,1.,0.5);
	}
	
    float rr=length(pos+float3(-shift.x,-3.03,1.85-tt))-.017;
    float fl=pos.y-3.013;
    float d=min(fl,length(p)/DEfactor-.0005);
	d=min(d,-pos.y+3.9);
    d=min(d,rr);
	if (abs(d-rr)<.0001) hitrock=1.;
	return hitrock;
}

float3 normal(float3 p, float3 shift, float tt, float deta) {
	float3 e = float3(0.0,deta,0.0);
	
	return normalize(float3(
			de(p+e.yxx, shift, tt)-de(p-e.yxx, shift, tt),
			de(p+e.xyx, shift, tt)-de(p-e.xyx, shift, tt),
			de(p+e.xxy, shift, tt)-de(p-e.xxy, shift, tt)
			)
		);	
}

float shadow(float3 pos, float3 shift, float3 sdir, float tt, float deta) {
		float totalDist =2.0*deta, sh=1.;
 		for (int steps=0; steps<30; steps++) {
			if (totalDist<1.) {
				float3 p = pos - totalDist * sdir;
				float dist = de(p, shift, tt)*1.5;
				if (dist < detail)  sh=0.;
				totalDist += max(0.05,dist);
			}
		}
		return max(0.,sh);	
}

float calcAO( const float3 pos, float3 shift, const float3 nor, float tt ) {
	float aodet=detail*80.;
	float totao = 0.0;
    float sca = 10.0;
    for( int aoi=0; aoi<5; aoi++ ) {
        float hr = aodet + aodet*float(aoi*aoi);
        float3 aopos =  nor * hr + pos;
        float dd = de( aopos, shift,  tt );
        totao += -(dd-hr)*sca;
        sca *= 0.75;
    }
    return clamp( 1.0 - 5.0*totao, 0.0, 1.0 );
}



float kset(float3 p) {
	p=abs(.5-frac(p*20.));
	float es, l=es=0.;
	for (int i=0;i<13;i++) {
		float pl=l;
		l=length(p);
		p=abs(p)/dot(p,p)-.5;
		es+=exp(-1./abs(l-pl));
	}
	return es;	
}

float3 light(in float3 p, in float3 shift, in float3 dir, in float2x2 rot, float tt, float deta) {

	float hf=getHitFloor(p, shift, tt);
	float hr=getHitRock(p, shift, tt);
	float3 n=normal(p, shift, tt, deta);
	float sh=clamp(shadow(p, shift, lightdir, tt, deta)+hf+hr,.4,1.);
	float ao=calcAO(p,shift,n,tt);
	float diff=max(0.,dot(lightdir,-n))*sh*1.3;
	float amb=max(0.2,dot(dir,-n))*.4;
	float3 r = reflect(lightdir,n);
	float spec=pow(max(0.,dot(dir,-r))*sh,10.)*(.5+ao*.5);
	float k=kset(p)*.18; 
	float3 col=lerp(float3(k*1.1,k*k*1.3,k*k*k),float3(k,k,k),.45)*2.;
	float3 pp=p-float3(0.,3.03,tt);
    pp.yz=mul(pp.yz,rot);
    if (hr>0.) col=float3(.9,.8,.7)*(1.+kset(pp*2.)*.3);
    col=col*ao*(amb*float3(.9,.85,1.)+diff*float3(1.,.9,.9))+spec*float3(1,.9,.5)*.7;	
	return col;
}


float3 raymarch(in float3 from, in float3 shift, in float3 dir, float tt) 
{
	float t=iTime;
	float cc=cos(t*.03); float ss=-sin(t*.03);
    float2x2 rot=float2x2(cc,ss,-ss,cc);
    float2 lig=float2(sin(t*2.)*.6,cos(t)*.25-.25);
	float fog,glow,d=1., totdist=glow=fog=0.;
	float3 p = float3(0.,0.,0.);
	float3 col=float3(0.,0.,0.);
	float ref=0.;
	float steps;
	float deta = 0.0;
	from += shift;
	for (int i=0; i<130; i++) {
		if (d>deta && totdist<3.5) {
			p=from+totdist*dir;
			d=de(p,shift,tt);
			
			deta=detail*(1.+totdist*55.);
			totdist+=d; 
			glow+=max(0.,.02-d)*exp(-totdist);
			steps++;
		}
	}
	float l=pow(max(0.,dot(normalize(-dir),normalize(lightdir))),10.);
	float3 backg=float3(.8,.85,1.)*.25*(2.-l)+float3(1.,.9,.65)*l*.4;
	float hf=getHitFloor(p, shift, tt);
	if (d<deta) {
		col=light(p-deta*dir*1.5, shift, dir,rot,tt,deta); 
		if (hf>0.5) col*=float3(1.,.85,.8)*.6;
		col*=min(1.2,.5+totdist*totdist*1.5);
		col = lerp(col, backg, 1.0-exp(-1.3*pow(totdist,1.3)));
	} else { 
		col=backg;
	}
	col+=glow*float3(1.,.9,.8)*.34;
	col+=float3(1,.8,.6)*pow(l,3.)*.5;
	return col; 
}

float4 psAncientTemple(VS_OUT In):SV_Target{
	float tt=iTime*.05;
	
    float2 q = 1-In.TexCd.rg;
	float2 uv = -1.0 + 2.0*q;
	
	float t=iTime*.15;
	float y=(cos(iTime*.1+3.)+1.);
	uv.y-=.1;
	float3 from=float3(0.0,3.04+y*.01,-2.+iTime*.05);
	float3 dir=normalize(In.PosW.xyz);
	float3 shift = float3(2.,0.,0.);
	float3 color=raymarch(from, shift, dir, tt); 
	color*=float3(1.,.94,.87);
	color=pow(color,float3(1.2,1.2,1.2));
	color=lerp(float3(length(color),length(color),length(color)),color,.85)*.95;
	color+=float3(1,.85,.7)*pow(max(0.,.3-length(uv-float2(0.,.03)))/.3,1.5)*.65;
	
	return float4(color,1.);
}

technique10 AncientTemple{
	pass P0{
		SetVertexShader(CompileShader(vs_4_0,VS()));
		SetPixelShader(CompileShader(ps_4_0,psAncientTemple()));
	}
}


