//@author: umanema
//@help: a skybox implementation of a shader from shadertoy
//@tags: skybox, raymarching, shadertoy
//@credits: Kali
//@license: Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.

#define ENABLE_HARD_SHADOWS
#define ENABLE_POSTPROCESS

#define RAY_STEPS 70
#define SHADOW_STEPS 50
#define LIGHT_COLOR float3(.85,.9,1.)
#define AMBIENT_COLOR float3(.8,.83,1.)
#define FLOOR_COLOR float3(1.,.7,.9)
#define ENERGY_COLOR float3(1.,.7,.4)
#define BRIGHTNESS .9
#define GAMMA 1.3
#define SATURATION .85

#define detail 0.00002
#define t iTime*.25

static const float3 origin = float3(0.,3.11,0.);

cbuffer cbControls:register(b0){
	float4x4 tW:WORLD;
	float4x4 tV:VIEW;
	float4x4 tP:PROJECTION;
	float4x4 tVI:VIEWINVERSE;
	float4x4 tPI:PROJECTIONINVERSE;
	float4x4 tWIT:WORLDINVERSETRANSPOSE;
	
	float3 lightdir=normalize(float3(0.5,-0.3,-1.));
	float3 ambdir=normalize(float3(0.,0.,1.));

	float iTime = 0.0;
};

struct VS_IN{
	float4 PosO:POSITION;
	float4 TexCd:TEXCOORD0;
};

struct VS_OUT{
	float4 PosWVP:SV_POSITION;
	float4 TexCd:TEXCOORD0;
	float4 PosW:TEXCOORD1;
};

VS_OUT VS(VS_IN In){
	VS_OUT Out=(VS_OUT)0;
	float4 PosW=In.PosO;
	PosW=mul(PosW,tW);
	Out.TexCd=In.TexCd;
	Out.PosW=PosW;
	Out.PosWVP=mul(PosW,mul(tV,tP));
	return Out;
}

float3 path(float ti) {
return float3(sin(ti),.3-sin(ti*.632)*.3,cos(ti*.5))*.5;
}

float Sphere(float3 p, float3 rd, float r){//A RAY TRACED SPHERE
	float b = dot( -p, rd );
	float inner = b * b - dot( p, p ) + r * r;
	if( inner < 0.0 ) return -1.0;
	return b - sqrt( inner );
}

float2 de(float3 pos) {
	float hid=0.;
	float3 tpos=pos;
	tpos.xz=abs(.5-fmod(tpos.xz,1.));
	float4 p=float4(tpos,1.);
	float y=max(0.,.35-abs(pos.y-3.35))/.35;
	for (int i=0; i<7; i++) {//LOWERED THE ITERS
		p.xyz = abs(p.xyz)-float3(-0.02,1.98,-0.02);
		p=p*(2.0)/clamp(dot(p.xyz,p.xyz),.4,1.)-float4(0.5,1.,0.4,0.);
		p.xz=mul(p.xz,float2x2(-0.416,-0.91,0.91,-0.416));
	}
	float fl=pos.y-3.013;
	float fr=(length(max(abs(p.xyz)-float3(0.1,5.0,0.1),float3(0.0,0.0,0.0)))-0.05)/p.w;//RETURN A RRECT
	//float fr=length(p.xyz)/p.w;
	float d=min(fl,fr);
	d=min(d,-pos.y+3.95);
	if (abs(d-fl)<.001) hid=1.;
	return float2(d,hid);
}


float3 normal(float3 p, float det) {
	float3 e = float3(0.0,det,0.0);
	
	return normalize(float3(
			de(p+e.yxx).x-de(p-e.yxx).x,
			de(p+e.xyx).x-de(p-e.xyx).x,
			de(p+e.xxy).x-de(p-e.xxy).x
			)
		);	
}

float shadow(float3 pos, float3 sdir, float3 pth1, float det) {//THIS ONLY RUNS WHEN WITH HARD SHADOWS
	float sh=1.0;
	float totdist =2.0*det;
	float dist=10.;
	float t1=Sphere((pos-.005*sdir)-pth1,-sdir,0.015);
	if (t1>0. && t1<.5) {
		float3 sphglowNorm=normalize(pos-t1*sdir-pth1);
		sh=1.-pow(max(.0,dot(sphglowNorm,sdir))*1.2,3.);
	} 
		for (int steps=0; steps<SHADOW_STEPS; steps++) {
			if (totdist<.6 && dist>detail) {
				float3 p = pos - totdist * sdir;
				dist = de(p).x;
				sh = min( sh, max(50.*dist/totdist,0.0) );
				totdist += max(.01,dist);
			}
		}
	
    return clamp(sh,0.1,1.0);
}


float calcAO( const float3 pos, const float3 nor ) {
	float aodet=detail*40.;
	float totao = 0.0;
    float sca = 14.0;
    for( int aoi=0; aoi<5; aoi++ ) {
        float hr = aodet*float(aoi*aoi);
        float3 aopos =  nor * hr + pos;
        float dd = de( aopos ).x;
        totao += -(dd-hr)*sca;
        sca *= 0.7;
    }
    return clamp( 1.0 - 5.0*totao, 0., 1.0 );
}

float _texture(float3 p) {
	p=abs(0.5-frac(p*10.));
	float3 c=float3(3.,3.,3.);
	float es, l=es=0.;
	for (int i = 0; i < 10; i++) { 
			p = abs(p + c) - abs(p - c) - p; 
			p/= clamp(dot(p, p), .0, 1.);
			p = p* -1.5 + c;
			if ( fmod(float(i), 2.) < 1. ) { 
				float pl = l;
				l = length(p);
				es+= exp(-1. / abs(l - pl));
			}
	}
	return es;
}

float3 light(in float3 p, in float3 dir, in float3 n, in float hid, in float3 pth1,
			 in float3 energy, in float det) {//PASSING IN THE NORMAL
	#ifdef ENABLE_HARD_SHADOWS
		float sh=shadow(p, lightdir, pth1, det);
	#else
		float sh=calcAO(p,-2.5*lightdir);//USING AO TO MAKE VERY SOFT SHADOWS
	#endif
	float ao=calcAO(p,n);
	float diff=max(0.,dot(lightdir,-n))*sh;
	float y=3.35-p.y;
	float3 amb=max(.5,dot(dir,-n))*.5*AMBIENT_COLOR;
	if (hid<.5) {
		amb+=max(0.2,dot(float3(0.,1.,0.),-n))*FLOOR_COLOR*pow(max(0.,.2-abs(3.-p.y))/.2,1.5)*2.;
		amb+=energy*pow(max(0.,.4-abs(y))/.4,2.)*max(0.2,dot(float3(0.,-sign(y),0.),-n))*2.;
	}
	float3 r = reflect(lightdir,n);
	float spec=pow(max(0.,dot(dir,-r))*sh,10.);
	float3 col;
	float energysource=pow(max(0.,.04-abs(y))/.04,4.)*2.;
	if (hid>1.5) {col=float3(1.,1.,1.); spec=spec*spec;}
	else{
		float k=_texture(p)*.23+.2; 
		k=min(k,1.5-energysource);
		col=lerp(float3(k,k*k,k*k*k),float3(k,k,k),.3);
		if (abs(hid-1.)<.001) col*=FLOOR_COLOR*1.3;
	}
	col=col*(amb+diff*LIGHT_COLOR)+spec*LIGHT_COLOR;	
	if (hid<.5) { 
		col=max(col,energy*2.*energysource);
	}
	col*=min(1.,ao+length(energy)*.5*max(0.,.1-abs(y))/.1);
	return col;
}

float3 raymarch(in float3 from, in float3 dir, in float3 pth1) 

{
	float det = 0.;
	float3 energy = float3(0.01,0.01,0.01);
	
	float ey=fmod(t*.5,1.);
	float glow,eglow,ref,sphdist,totdist=glow=eglow=ref=sphdist=0.0;
	float2 d=float2(1.0,0.0);
	float3 p, col=float3(0.,0.,0.);
	float3 origdir=dir,origfrom=from,sphNorm;
	
	//FAKING THE SQUISHY BALL BY MOVING A RAY TRACED BALL
	float3 wob=cos(dir*500.0*length(from-pth1)+(from-pth1)*250.+iTime*10.)*0.0005;
	float t1=Sphere(from-pth1+wob,dir,0.015);
	float tg=Sphere(from-pth1+wob,dir,0.02);
	if(t1>0.){
		ref=1.0;from+=t1*dir;sphdist=t1;
		sphNorm=normalize(from-pth1+wob);
		dir=reflect(dir,sphNorm);
	} 
	else if (tg>0.) { 
		float3 sphglowNorm=normalize(from+tg*dir-pth1+wob);
		glow+=pow(max(0.,dot(sphglowNorm,-dir)),5.);
	};
	
	for (int i=0; i<RAY_STEPS; i++) {
		if (d.x>det && totdist<3.0) {
			p=from+totdist*dir;
			d=de(p);
			det=detail*(1.+totdist*60.)*(1.+ref*5.);
			totdist+=d.x;
			energy=ENERGY_COLOR*(1.5+sin(iTime*20.+p.z*10.))*.25;
			if(d.x<0.015)glow+=max(0.,.015-d.x)*exp(-totdist);
			if (d.y<.5 && d.x<0.03){//ONLY DOING THE GLOW WHEN IT IS CLOSE ENOUGH
				float glw=min(abs(3.35-p.y-ey),abs(3.35-p.y+ey));//2 glows at once
				eglow+=max(0.,.03-d.x)/.03*
				(pow(max(0.,.05-glw)/.05,5.)
				+pow(max(0.,.15-abs(3.35-p.y))/.15,8.))*1.5;
			}
		}
	}
	float l=pow(max(0.,dot(normalize(-dir.xz),normalize(lightdir.xz))),2.);
	l*=max(0.2,dot(-dir,lightdir));
	float3 backg=.5*(1.2-l)+LIGHT_COLOR*l*.7;
	backg*=AMBIENT_COLOR;
	if (d.x<=det) {
		float3 norm=normal(p-abs(d.x-det)*dir, det);//DO THE NORMAL CALC OUTSIDE OF LIGHTING (since we already have the sphere normal)
		col=light(p-abs(d.x-det)*dir, dir, norm, d.y, pth1, energy, det)*exp(-.2*totdist*totdist); 
		col = lerp(col, backg, 1.0-exp(-1.*pow(totdist,1.5)));
	} else { 
		col=backg;
	}
	float3 lglow=LIGHT_COLOR*pow(l,30.)*.5;
	col+=glow*(backg+lglow)*1.3;
	col+=pow(eglow,2.)*energy*.015;
	col+=lglow*min(1.,totdist*totdist*.3);
	if (ref>0.5) {
		float3 sphlight=light(origfrom+sphdist*origdir,origdir,sphNorm,2.,pth1, energy, det);
		col=lerp(col*.3+sphlight*.7,backg,1.0-exp(-1.*pow(sphdist,1.5)));
	}
	return col; 
}

float3 move(inout float2x2 rotview1,inout float2x2 rotview2) {
	float3 go=path(t);
	float3 adv=path(t+.7);
	float3 advec=normalize(adv-go);
	float an=atan2(advec.x,advec.z);
	rotview1=float2x2(cos(an),sin(an),-sin(an),cos(an));
		  an=advec.y*1.7;
	rotview2=float2x2(cos(an),sin(an),-sin(an),cos(an));
	return go;
}


float4 psGenerators(VS_OUT In):SV_Target{
	float3 pth1 = path(t+.3)+origin+float3(0.,.01,0.)+float3(16.,0.,16.);
	float2 q = 1-In.TexCd.rg;
	float2 uv = -1.0 + 2.0*q;
	float2 uv2=uv;
	
	#ifdef ENABLE_POSTPROCESS
	uv*=1.+pow(length(uv2*uv2*uv2*uv2),4.)*.07;
	#endif
	
	float2x2 rotview1, rotview2;
	float3 from=origin+move(rotview1,rotview2)+float3(16.,0.,16.);
	float3 dir=normalize(In.PosW.xyz);
	float3 color=raymarch(from, dir, pth1);
	color=clamp(color,float3(.0,.0,.0),float3(1.,1.,1.));
	color=pow(color,float3(GAMMA,GAMMA,GAMMA))*BRIGHTNESS;
	color=lerp(float3(length(color),length(color),length(color)),color,SATURATION);

	//post processing effects is written for 2D shaders,
	//so they have to be rewritten, and I've commented them for now
	
	#ifdef ENABLE_POSTPROCESS
	//float3 rain=pow(tex.SampleLevel(s0,uv2+iTime*7.25468,0.0).rgb,float3(1.5,1.5,1.5));
	//color=lerp(rain,color,clamp(iTime*.5-.5,0.,1.));
	//uv2.y *= iResolution.y / 360.0;
	//color.r*=(.5+abs(.5-fmod(uv2.y     ,.021)/.021)*.5)*1.5;
	//color.g*=(.5+abs(.5-fmod(uv2.y+.007,.021)/.021)*.5)*1.5;
	//color.b*=(.5+abs(.5-fmod(uv2.y+.014,.021)/.021)*.5)*1.5;
	//color*=.9+rain*.35;
	#endif
	
	return float4(color,1.);
}


technique10 Generators{
	pass P0{
		SetVertexShader(CompileShader(vs_4_0,VS()));
		SetPixelShader(CompileShader(ps_4_0,psGenerators()));
	}
}


