//       ���������������������������������������������������������������������
//       ���������������������������������������������������������������������
//       ���������������������2009 kalle������������������������������
//       ��������������������������������������������������������������������
//       ��������������������������������������������������������������������
//       _________________________________________________________________________________
//       ���������<   SEMANTICS   >�������������������������������������������������������
//       ���������������������������������������������������������������������������������
         float4x4 tW        : WORLD ;          //����< object space -> world space>�������
                              //holds the transformation connected to the "Transform" pin.
                              //multiply the points of your mesh with that matrix
                              //so that you can transform meshes in space.
         float4x4 tV        : VIEW   ;                //   world space -> view space
                              //this is the transformation you connected to the renderer at pin "View Transform".
                              //this matrix normally holds the position and orientation of the camera.
                              //multiply the points of your mesh to get them relative to the camera.
                              //still no distortion has taken place.
                              //after multiplication x goes right, y goes up and z goes into the monitor.
         float4x4 tP        : PROJECTION   ;          //view space -> projection space
                              //this is the transformation you connected to the renderer at pin "Projection Transform". it normally holds a perspective transformation.
                              //multiply the points of your mesh to distort them by a lens.
                              //after multiplication x and y values in between -1 and 1 are visible in the renderer.
                              //                     points wiht z=0 are in front (NearClipping Plane),
                              //                     points with z=1 are behind (Far Clipping Plane).
         float4x4 tWVP      : WORLDVIEWPROJECTION ;    //object space -> projection space *
                              //very comfortable matrix to get points from the original mesh
                              //relative to the camera and also distorted by its lens.
//       _________________________________________________________________________________
//       ���������<   PARAMETER   >�������������������������������������������������������
//       ���������������������������������������������������������������������������������

float4 TexCol : COLOR <String uiname="Color";>              = {1, 1, 1, 1};
float4 MouseCol : COLOR <String uiname="Cursor Color";>              = {1, 0, 0, 1};

float2 LineWidth <String uiname="Line Width";> = ( 0.003 , 0.004 ) ;
float2 Size <String uiname="Cursor Size";> = ( 0.06 , 0.08 ) ;     //

float4   SwitchLine            <String uiname="Enable";>        = {1, 0, 0, 1};
float Alpha = 1;

float MouseX=0;
float MouseY=0;
float MouseWheel = 0 ;
bool  Left          <String uiname="Left Button";>        = 0;
bool  Middle        <String uiname="Middle Button";>      = 0;
bool  Right         <String uiname="Right Button";>       = 0;


float MagFactor     <String uiname="Magnifying Factor";>  = 1.5;

//       _________________________________________________________________________________
//       ���������<   CONSTANTS    >������������������������������������������������������
//       ���������������������������������������������������������������������������������

#define       PI 3.141592655

//       _________________________________________________________________________________
//       ���������<   TEXTURES    >�������������������������������������������������������
//       ���������������������������������������������������������������������������������

//          _____
//       __/  1  \________________________________________________________________________
//       ���������������������������������������������������������������������������������
texture  Tex       <string uiname = "Texture" ; > ;
sampler  Samp      =      sampler_state           //sampler for doing the texture-lookup
         {
         Texture   = (Tex) ;  //apply a texture to the sampler
         MipFilter = LINEAR;  //  LINEAR;   POINT;   NONE;   ANISOTROPIC;  PYRAMIDALQUAD;   GAUSSIANQUAD;    CONVOLUTIONMONO;  FORCE_DWORD;
         MinFilter = LINEAR;  //  LINEAR;   POINT;   NONE;   ANISOTROPIC;  PYRAMIDALQUAD;   GAUSSIANQUAD;    CONVOLUTIONMONO;  FORCE_DWORD;
         MagFilter = LINEAR;  //  LINEAR;   POINT;   NONE;   ANISOTROPIC;  PYRAMIDALQUAD;   GAUSSIANQUAD;    CONVOLUTIONMONO;  FORCE_DWORD;
         AddressU  = WRAP  ;  //  CLAMP;    WRAP;    MIRROR; BORDER;       MIRRORONCE;
         AddressV  = WRAP  ;  //  CLAMP;    WRAP;    MIRROR; BORDER;       MIRRORONCE;
         }  ;

float4x4 tTex: TEXTUREMATRIX <string uiname="Texture Transform";>;


//       _________________________________________________________________________________
//       ���������<   VERTEX SHADERS    >�������������������������������������������������
//       ���������������������������������������������������������������������������������
//       TexCd.x = 0 means the far left of the screen (or texture)
//       TexCd.x = 1 means the far right of the screen (or texture)
//       TexCd.x = 0.5 means the exact center of the screen (or texture)
//       TexCd.y = 0 means the very top of the screen (or texture)
//       TexCd.y = 1 means the very bottom of the screen (or texture)
//       TexCd.y = 0.5 means the exact center of the screen (or texture)

//          _____
//       __/  1  \________________________________________________________________________
//       ���������������������������������������������������������������������������������
         struct vs2ps
                     {
                     float4 Pos : POSITION;
                     float4 TexCd : TEXCOORD0;
                     };

         vs2ps VS    (
                      float4 Pos : POSITION,
                      float4 TexCd : TEXCOORD0
                     )
               {
               //inititalize all fields of output struct with 0
               vs2ps Out = (vs2ps)0;

               //transform position
               Out.Pos = mul(Pos, tWVP);

               //transform texturecoordinates
               Out.TexCd = mul(TexCd, tTex);

               return Out;
               }

//       _________________________________________________________________________________
//       ���������<   FUNCTIONS    >������������������������������������������������������
//       ���������������������������������������������������������������������������������
//          _____
//       __/  1  \________________________________________________________________________
//       ���������������������������������������������������������������������������������
float4   Circle      (
                     uniform float2 UV ,
                     uniform float4 InColor ,
                     uniform float2 LineSize ,
                     uniform float2 Scale
                     )  :    COLOR
         {
          //In.TexCd = In.TexCd / In.TexCd.w; // for perpective texture projections (e.g. shadow maps) ps_2_0
          //LineSize /= sqrt(2);
          float2 Mouse  = {MouseX , MouseY };
          float4 col    =  InColor;//tex2D(Samp, In.TexCd) * TexCol;//tex2D(Samp, In.TexCd) * cAmb;  // = ( 0f,0f,0f,0f); //
                LineSize *= 2;
          if   (
               distance ( UV/(Size + LineSize)  ,   Mouse/ (Size+  LineSize )   ) < 0.5
               &&
               distance ( UV/(Size  )  ,   Mouse/ (Size )   ) > 0.5
               &&
               SwitchLine.x  > 0
               )
               {col = MouseCol;}

          return col;
         }
//       ����������������������������������������������������������������������������������


//                 _____
//       _________/  2  \__________________________________________________________________
//       ����������������������������������������������������������������������������������
 float4  Rectangle   (
                     uniform float2 UV ,
                     uniform float4 InColor ,
                     uniform float2 LineSize ,
                     uniform float2 Scale
                     )  :    COLOR
         {
          //In.TexCd = In.TexCd / In.TexCd.w; // for perpective texture projections (e.g. shadow maps) ps_2_0


          float2 Mouse     =  { MouseX , MouseY } ;
          float4 col       =  InColor;//tex2D(Samp, In.TexCd) * TexCol;//tex2D(Samp, In.TexCd) * cAmb;  // = ( 0f,0f,0f,0f); //
                 LineSize /=  sqrt ( 2 ) ;
          if     (
                     (
                     distance( UV.x ,  MouseX ) >= Size.x/2
                     ||
                     distance( UV.y ,  MouseY ) >= Size.y/2
                     )
                 &&
                     (
                     distance( UV.x ,MouseX) <= Size.x/2+LineWidth.x
                     &&
                     distance( UV.y ,MouseY) <= Size.y/2+LineWidth.y
                     )
                 &&
                 SwitchLine.y  > 0
                 )
                 {  col = MouseCol; }

          return col;
         }
//       ����������������������������������������������������������������������������������
//                        _____
//       ________________/  3  \___________________________________________________________
//       ����������������������������������������������������������������������������������
float4   InnerCrosshair    ( uniform float2 UV  ,
                             uniform float4 InColor ,
                             uniform float2 LineSize ,
                             uniform float2 CursorScale
                           ):        COLOR
         {
         //In.TexCd = In.TexCd / In.TexCd.w; // for perpective texture projections (e.g. shadow maps) ps_2_0
         LineSize /= 2;
         float4 OutCol = InColor;// //tex2D(Samp, In.TexCd) * cAmb;  // = ( 0f,0f,0f,0f); //
         if     (
                distance (MouseX ,UV.x) <= LineSize.x
                &&
                distance (MouseY , UV.y) <= CursorScale.y/2
                &&
                SwitchLine.z  > 0
                )
                {OutCol = MouseCol;}
         if     (
                distance (MouseY ,UV.y) <= LineSize.y
                &&
                distance (MouseX ,UV.x) <= CursorScale.x/2
                && SwitchLine.z  > 0
                )
                {OutCol = MouseCol;}

         return OutCol;
         }
//       ����������������������������������������������������������������������������������
//                               _____
//       _______________________/  4  \____________________________________________________
//       ����������������������������������������������������������������������������������
float4   OuterCrosshair    ( uniform float2 UV  ,
                             uniform float4 InColor ,
                             uniform float2 LineSize ,
                             uniform float2 CursorScale
                            )   :    COLOR
         {
         //In.TexCd = In.TexCd / In.TexCd.w; // for perpective texture projections (e.g. shadow maps) ps_2_0
         LineSize /= 2;
         float4 OutCol = InColor;// //tex2D(Samp, In.TexCd) * cAmb;  // = ( 0f,0f,0f,0f); //
         if     (
                distance (MouseX ,UV.x) <= LineSize.x
                &&
                distance (MouseY , UV.y) >= CursorScale.y/2
                &&
                SwitchLine.w  > 0
                )
                {OutCol = MouseCol;}
         if     (
                distance (MouseY ,UV.y) <= LineSize.y
                &&
                distance (MouseX , UV.x) >= CursorScale.x/2
                &&
                SwitchLine.w  > 0
                )
                {OutCol = MouseCol;}

         return OutCol;
         }
//       ����������������������������������������������������������������������������������
//                                      _____
//       ______________________________/  5  \_____________________________________________
//       ����������������������������������������������������������������������������������
//       credits to Rob Galanakis   ---  http://www.robg3d.com/commonFunctions.html
         float Luminance (float4 ColorIn )
               {
                float maxRGB  = max ( max (  ColorIn.r , ColorIn.g ) , ColorIn.b ) ;
                float minRGB  = min ( min (  ColorIn.r , ColorIn.g ) , ColorIn.b ) ;
                float Luminance = ((maxRGB + minRGB)/2);
                return Luminance;
               }
//       ����������������������������������������������������������������������������������
//                                             _____
//       _____________________________________/  6  \______________________________________
//       ����������������������������������������������������������������������������������
         float MaxCol (float4 ColorIn )
               {
               float maxRGB  = max ( max (  ColorIn.r , ColorIn.g ) , ColorIn.b ) ;
               return maxRGB;
               }
//       ����������������������������������������������������������������������������������
//                                                    _____
//       ____________________________________________/  7  \_______________________________
//       ����������������������������������������������������������������������������������
         float MinCol (float4 ColorIn )
               {
               float minRGB  = min ( min (  ColorIn.r , ColorIn.g ) , ColorIn.b ) ;
               return minRGB;
               }
//       ����������������������������������������������������������������������������������

//       _________________________________________________________________________________
//       ���������<   PIXEL SHADERS     >�������������������������������������������������
//       ���������������������������������������������������������������������������������

//          _____
//       __/  1  \________________________________________________________________________
//       ���������������������������������������������������������������������������������

float4   SimpleCursor ( vs2ps In )      : COLOR
         {
                MouseX +=  1.0;
                MouseX *=  0.5;
                MouseY -=  1.0;
                MouseY *= -0.5;
                
         float4 OutCol    = tex2D ( Samp, In.TexCd ) * TexCol;
                 MouseCol.rgb     = Left * (1-MouseCol.rgb) + (1-Left)*MouseCol.rgb;
                OutCol    = Circle         ( In.TexCd, OutCol , LineWidth , Size );
                OutCol    = Rectangle      ( In.TexCd, OutCol , LineWidth , Size );
                OutCol    = InnerCrosshair ( In.TexCd, OutCol , LineWidth , Size );
                OutCol    = OuterCrosshair ( In.TexCd, OutCol , LineWidth , Size );
                
                OutCol.a *= Alpha;
         return OutCol;
         }
//                 _____
//       _________/  2  \__________________________________________________________________
//       ����������������������������������������������������������������������������������

float4   ColorShiftCursor ( vs2ps In )      : COLOR
         {
                MouseX +=  1.0;
                MouseX *=  0.5;
                MouseY -=  1.0;
                MouseY *= -0.5;
                
         float4 OutCol    = tex2D ( Samp, In.TexCd ) * TexCol;

                //
                //MouseCol.rgb   += 1.0  ;
                  //MouseCol.rgb   *= Luminance(OutCol)  ;
                //  MouseCol.rgb    *= lerp( MinCol (MouseCol ) , MaxCol (MouseCol ), Luminance(OutCol) );
                //MouseCol.rgb  +=   OutCol.rgb;
                MouseCol.rgb     =  (
                                       (    1- MinCol (MouseCol  ) ) * ( Luminance(OutCol))
                                       
                                       +  MouseCol * Luminance(OutCol)
                                       
                                       //-  MouseCol
                                    )
                                   // +  (    (     (MouseCol ) )   * ( 1- Luminance(OutCol)  )  )

                                    ;

                 MouseCol.rgb =   (MouseCol.rgb% 1)    ;
                
                OutCol    = Circle         ( In.TexCd, OutCol , LineWidth , Size );
                OutCol    = Rectangle      ( In.TexCd, OutCol , LineWidth , Size );
                OutCol    = InnerCrosshair ( In.TexCd, OutCol , LineWidth , Size );
                OutCol    = OuterCrosshair ( In.TexCd, OutCol , LineWidth , Size );
                OutCol.a *= Alpha;
         return OutCol;
         }
//       ����������������������������������������������������������������������������������
//                        _____
//       ________________/  3  \___________________________________________________________
//       ����������������������������������������������������������������������������������
float4   RoundMagGlass ( vs2ps In ): COLOR
         {
         float2 UV         =  In.TexCd ;
         MouseX           *=  0.5;
                  MouseY  *= -0.5;
         MouseX           +=  0.5;
                  MouseY  +=  0.5;
         float2 Mouse      = { MouseX , MouseY } ;
                MagFactor  =  1 / MagFactor       ;
         float4 OutCol     = tex2D ( Samp, In.TexCd ) * TexCol;
         
         if     (
                distance ( In.TexCd/Size,Mouse/Size) < 0.5
                )
            {
            UV =  Mouse +  MagFactor *(UV-Mouse);
            OutCol = tex2D(Samp, UV) * TexCol;
            } // {  UV = Mouse +  pow(3*distance( UV ,Mouse), .4)  *(UV-Mouse); }
         if     (
                distance ( In.TexCd/(Size+ length(LineWidth)),Mouse/(Size+ length(LineWidth))) > 0.5
                )
            {
            OutCol = tex2D(Samp, UV) * TexCol;
            }
                OutCol    = Circle         ( In.TexCd, OutCol , LineWidth , Size );
                OutCol    = Rectangle      ( In.TexCd, OutCol , LineWidth , Size );
                OutCol    = InnerCrosshair ( In.TexCd, OutCol , LineWidth , Size );
                OutCol    = OuterCrosshair ( In.TexCd, OutCol , LineWidth , Size );
                OutCol.a *= Alpha;
         return OutCol;
         }
//       ����������������������������������������������������������������������������������
//                               _____
//       _______________________/  4  \____________________________________________________
//       ����������������������������������������������������������������������������������
float4   RectMagGlass ( vs2ps In ): COLOR
         {
         float2 UV = In.TexCd ;
         
         MouseX            *=  0.5;
                  MouseY   *= -0.5;
         MouseX            +=  0.5;
                  MouseY   +=  0.5;
         float2   Mouse     =  { MouseX , MouseY };
                  MagFactor =  1 / MagFactor ;
         
         float4   OutCol    = tex2D ( Samp, In.TexCd ) * TexCol;
         if       (
                  distance ( In.TexCd.x ,  MouseX ) < Size.x/2
                  &&
                  distance( In.TexCd.y ,  MouseY ) < Size.y/2
                  )
            {
            UV =  Mouse +  MagFactor *(UV-Mouse);
            OutCol = tex2D(Samp, UV) * TexCol;
            }
         if       (
                  distance( UV.x ,MouseX) > Size.x+LineWidth.x
                  ||
                  distance( UV.y ,MouseY) > Size.y+LineWidth.y
                  )
            {
            OutCol = tex2D(Samp, UV) * TexCol;
            }
         OutCol    = Circle         ( In.TexCd, OutCol , LineWidth , Size );
         OutCol    = Rectangle      ( In.TexCd, OutCol , LineWidth , Size );
         OutCol    = InnerCrosshair ( In.TexCd, OutCol , LineWidth , Size );
         OutCol    = OuterCrosshair ( In.TexCd, OutCol , LineWidth , Size );
         OutCol.a *= Alpha;
         
         return OutCol;
         }



//       ����������������������������������������������������������������������������������
//                               _____
//       _______________________/  5  \____________________________________________________
//       ����������������������������������������������������������������������������������

float4   RoundColorPicker ( vs2ps In ): COLOR
         {
         float2 UV         =  In.TexCd ;
         MouseX           *=  0.5;
                  MouseY  *= -0.5;
         MouseX           +=  0.5;
                  MouseY  +=  0.5;
         float2 Mouse      = { MouseX , MouseY } ;

         float4 OutCol     = tex2D ( Samp, In.TexCd ) * TexCol;

         if     (
                distance ( In.TexCd/Size,Mouse/Size) < 0.5
                )
            {
            UV =  Mouse ;
            OutCol = tex2D(Samp, UV) * TexCol;
            } // {  UV = Mouse +  pow(3*distance( UV ,Mouse), .4)  *(UV-Mouse); }
         if     (
                distance ( In.TexCd/(Size+ length(LineWidth)),Mouse/(Size+ length(LineWidth))) > 0.5
                )
            {
            OutCol = tex2D(Samp, UV) * TexCol;
            }
                OutCol    = Circle         ( In.TexCd, OutCol , LineWidth , Size );
                OutCol    = Rectangle      ( In.TexCd, OutCol , LineWidth , Size );
                OutCol    = InnerCrosshair ( In.TexCd, OutCol , LineWidth , Size );
                OutCol    = OuterCrosshair ( In.TexCd, OutCol , LineWidth , Size );
                OutCol.a *= Alpha;
         return OutCol;
         }
//       ����������������������������������������������������������������������������������
//                               _____
//       _______________________/  6  \____________________________________________________
//       ����������������������������������������������������������������������������������
float4   RectColorPicker ( vs2ps In ): COLOR
         {
         float2 UV = In.TexCd ;

         MouseX            *=  0.5;
                  MouseY   *= -0.5;
         MouseX            +=  0.5;
                  MouseY   +=  0.5;
         float2   Mouse     =  { MouseX , MouseY };
                  MagFactor =  1 / MagFactor ;

         float4   OutCol    = tex2D ( Samp, In.TexCd ) * TexCol;
         if       (
                  distance ( In.TexCd.x ,  MouseX ) < Size.x/2
                  &&
                  distance( In.TexCd.y ,  MouseY ) < Size.y/2
                  )
            {
            UV =  Mouse ;
            OutCol = tex2D(Samp, UV) * TexCol;
            }
         if       (
                  distance( UV.x ,MouseX) > Size.x+LineWidth.x
                  ||
                  distance( UV.y ,MouseY) > Size.y+LineWidth.y
                  )
            {
            OutCol = tex2D(Samp, UV) * TexCol;
            }
         OutCol    = Circle         ( In.TexCd, OutCol , LineWidth , Size );
         OutCol    = Rectangle      ( In.TexCd, OutCol , LineWidth , Size );
         OutCol    = InnerCrosshair ( In.TexCd, OutCol , LineWidth , Size );
         OutCol    = OuterCrosshair ( In.TexCd, OutCol , LineWidth , Size );
         OutCol.a *= Alpha;

         return OutCol;
         }

// --------------------------------------------------------------------------------------------------
// TECHNIQUES:
// --------------------------------------------------------------------------------------------------

technique CursorSimple
{
    pass Textur
    {
        //Wrap0 = U;  // useful when mesh is round like a sphere
        VertexShader = compile vs_1_0    VS           ( );
        PixelShader  = compile ps_2_a    SimpleCursor ( );
    }

}

technique CursorColorShiftCursor
{
    pass P0
    {
        //Wrap0 = U;  // useful when mesh is round like a sphere
        VertexShader = compile vs_1_0 VS();
        PixelShader = compile ps_2_a ColorShiftCursor ( );
    }
}
technique CursorRoundMagGlass
{
    pass P0
    {
        //Wrap0 = U;  // useful when mesh is round like a sphere
        VertexShader = compile vs_1_0 VS();
        PixelShader = compile ps_2_a RoundMagGlass ( );
    }
}
technique RectangularMagGlass
{
    pass P0
    {
        //Wrap0 = U;  // useful when mesh is round like a sphere
        VertexShader = compile vs_1_0 VS();
        PixelShader = compile ps_2_a RectMagGlass ( );
    }
}
technique CursorRoundColorPicker
{
    pass P0
    {
        //Wrap0 = U;  // useful when mesh is round like a sphere
        VertexShader = compile vs_1_0 VS();
        PixelShader = compile ps_2_a RoundColorPicker ( );
    }
}
technique RectangularColorPicker
{
    pass P0
    {
        //Wrap0 = U;  // useful when mesh is round like a sphere
        VertexShader = compile vs_1_0 VS();
        PixelShader = compile ps_2_a RectColorPicker ( );
    }
}
