//@author: kalle
//@help: replace parts of a texture depending on Hue Saturation and Brightness
//@tags: sift, quick mapping, mask
//@credits:


//       _________________________________________________________________________________
//       ���������<   SEMANTICS   >�������������������������������������������������������
//       ���������������������������������������������������������������������������������
         float4x4 tW        : WORLD ;          //����< object space -> world space>�������
                              //holds the transformation connected to the "Transform" pin.
                              //multiply the points of your mesh with that matrix
                              //so that you can transform meshes in space.
         float4x4 tV        : VIEW   ;                //   world space -> view space
                              //this is the transformation you connected to the renderer at pin "View Transform".
                              //this matrix normally holds the position and orientation of the camera.
                              //multiply the points of your mesh to get them relative to the camera.
                              //still no distortion has taken place.
                              //after multiplication x goes right, y goes up and z goes into the monitor.
         float4x4 tP        : PROJECTION   ;          //view space -> projection space
                              //this is the transformation you connected to the renderer at pin "Projection Transform". it normally holds a perspective transformation.
                              //multiply the points of your mesh to distort them by a lens.
                              //after multiplication x and y values in between -1 and 1 are visible in the renderer.
                              //                     points wiht z=0 are in front (NearClipping Plane),
                              //                     points with z=1 are behind (Far Clipping Plane).
         float4x4 tWVP      : WORLDVIEWPROJECTION ;    //object space -> projection space *
                              //very comfortable matrix to get points from the original mesh
                              //relative to the camera and also distorted by its lens.

//       _________________________________________________________________________________
//       ���������<   PARAMETER   >�������������������������������������������������������
//       ���������������������������������������������������������������������������������



texture  Tex        < string uiname = "Reference Texture"  ; > ;
sampler  Samp    = sampler_state //sampler for doing the texture-lookup
         {
         Texture   = ( Tex ) ;
         MipFilter = LINEAR  ;  //  LINEAR;   POINT;   NONE  ;   ANISOTROPIC;  PYRAMIDALQUAD;   GAUSSIANQUAD;    CONVOLUTIONMONO;
         MinFilter = LINEAR  ;  //  LINEAR;   POINT;   NONE  ;   ANISOTROPIC;  PYRAMIDALQUAD;   GAUSSIANQUAD;    CONVOLUTIONMONO;
         MagFilter = LINEAR  ;  //  LINEAR;   POINT;   NONE  ;   ANISOTROPIC;  PYRAMIDALQUAD;   GAUSSIANQUAD;    CONVOLUTIONMONO;
         AddressU  = WRAP    ;  //  CLAMP ;   WRAP ;   MIRROR;   BORDER     ;  MIRRORONCE   ;
         AddressV  = WRAP    ;  //  CLAMP ;   WRAP ;   MIRROR;   BORDER     ;  MIRRORONCE   ;
         } ;

float4   RefCol  : COLOR <String uiname="Reference Color";>  = {0.15, 0.15, 0.15, 1};


float    HueTol   <String uiname="Hue Tolerance";>         = 0.1;
float    SatTol   <String uiname="Saturation Tolerance";>  = 0.1;
float    ValTol   <String uiname="Value Tolerance";>       = 0.1;






float4   ReplaceMatchRefColor     : COLOR < String uiname="MATCH Color Replacement"    ; >  = {0, 0, 1, 1};

bool     SwitchMatchColTex     < String uiname="MATCH: use Texture"    ; >  = 0;

texture  MatchReplaceTex  < string uiname = "MATCH Texture Replacement" ; > ;
sampler  MatchReplaceSamp = sampler_state
         {
         Texture   = ( MatchReplaceTex ) ;
         MipFilter = LINEAR  ;  //  LINEAR;   POINT;   NONE  ;   ANISOTROPIC;  PYRAMIDALQUAD;   GAUSSIANQUAD;    CONVOLUTIONMONO;
         MinFilter = LINEAR  ;  //  LINEAR;   POINT;   NONE  ;   ANISOTROPIC;  PYRAMIDALQUAD;   GAUSSIANQUAD;    CONVOLUTIONMONO;
         MagFilter = LINEAR  ;  //  LINEAR;   POINT;   NONE  ;   ANISOTROPIC;  PYRAMIDALQUAD;   GAUSSIANQUAD;    CONVOLUTIONMONO;
         AddressU  = WRAP    ;  //  CLAMP ;   WRAP ;   MIRROR;   BORDER     ;  MIRRORONCE   ;
         AddressV  = WRAP    ;  //  CLAMP ;   WRAP ;   MIRROR;   BORDER     ;  MIRRORONCE   ;
         } ;
//       ����������������������������������������������������������������������������������
//                        _____
//       ________________/  3  \___________________________________________________________
//       ����������������������������������������������������������������������������������
float4   ReplaceNONmatchRefColor  : COLOR < String uiname="NONMATCH Color Replacement" ; >  = {0, 0, 0, 0};

bool     SwitchNONmatchColTex  < String uiname="NONMATCH: use Texture" ; >  = 0;

texture  NONmatchReplaceTex   < string uiname = "NONMATCH Texture Replacement" ; > ;
sampler  NONmatchReplaceSamp  = sampler_state
         {
          Texture   = ( NONmatchReplaceTex ) ;
         MipFilter = LINEAR  ;  //  LINEAR;   POINT;   NONE  ;   ANISOTROPIC;  PYRAMIDALQUAD;   GAUSSIANQUAD;    CONVOLUTIONMONO;
         MinFilter = LINEAR  ;  //  LINEAR;   POINT;   NONE  ;   ANISOTROPIC;  PYRAMIDALQUAD;   GAUSSIANQUAD;    CONVOLUTIONMONO;
         MagFilter = LINEAR  ;  //  LINEAR;   POINT;   NONE  ;   ANISOTROPIC;  PYRAMIDALQUAD;   GAUSSIANQUAD;    CONVOLUTIONMONO;
         AddressU  = WRAP    ;  //  CLAMP ;   WRAP ;   MIRROR;   BORDER     ;  MIRRORONCE   ;
         AddressV  = WRAP    ;  //  CLAMP ;   WRAP ;   MIRROR;   BORDER     ;  MIRRORONCE   ;
         } ;
//       ����������������������������������������������������������������������������������

float4x4 tTex: TEXTUREMATRIX <string uiname="Texture Transform";>;
float4x4 tCol <string uiname="Color Transform";>;





//       _________________________________________________________________________________
//       ���������<   VERTEX SHADERS    >�������������������������������������������������
//       ���������������������������������������������������������������������������������
//       TexCd.x = 0 means the far left of the screen (or texture)
//       TexCd.x = 1 means the far right of the screen (or texture)
//       TexCd.x = 0.5 means the exact center of the screen (or texture)
//       TexCd.y = 0 means the very top of the screen (or texture)
//       TexCd.y = 1 means the very bottom of the screen (or texture)
//       TexCd.y = 0.5 means the exact center of the screen (or texture)

//          _____
//       __/  1  \________________________________________________________________________
//       ���������������������������������������������������������������������������������
struct vs2ps   {

               float4 Pos   : POSITION;
               float4 TexCd : TEXCOORD0;
               };

vs2ps VS       ( float4 Pos    : POSITION, float4 TexCd  : TEXCOORD0 )
               { vs2ps Out = (vs2ps)0;   //inititalize all fields of output struct with 0
               Out.Pos = mul(Pos, tWVP);   //transform position
               
               TexCd.w = -99;
               Out.TexCd = mul(TexCd, tTex);    //transform texturecoordinates
               return Out;
               }




//       _________________________________________________________________________________
//       ���������<   FUNCTIONS    >������������������������������������������������������
//       ���������������������������������������������������������������������������������
//          _____
//       __/  1  \________________________________________________________________________
//       ���������������������������������������������������������������������������������
float4   RGBAtoHSVA (  float4 RGBA  )
         {
         float  DELTA, RGBmax, RGBmin, Hue=0, Saturation=0, Value=0;
         float4 HSVA;
         RGBmax = max ( RGBA.r , RGBA.g ) ;
         RGBmax = max ( RGBmax     , RGBA.b ) ;
         RGBmin = min ( RGBA.r , RGBA.g ) ;
         RGBmin = min ( RGBmin  , RGBA.b ) ;
         Value = RGBmax;               // this is the result
HSVA.z = Value;

         if ( RGBmax != 0) { Saturation = ( RGBmax - RGBmin ) / RGBmax ; }
HSVA.y = Saturation;
         if (Saturation != 0) // if not achromatic
                              {
                              DELTA = RGBmax - RGBmin ;
                                    if ( RGBA.r == RGBmax )
                                          { Hue = ( RGBA.g - RGBA.b ) / DELTA ; }
                              else  if ( RGBA.g == RGBmax )
                                          { Hue = 2.0 +  ( RGBA.b - RGBA.r ) / DELTA ; }
                              else        { Hue  = 4.0 + ( RGBA.r - RGBA.g ) / DELTA ; }
         Hue *= 60;
         if( Hue < 0)       { Hue +=360; }
         Hue = Hue / 360.0;    // moving h to be between 0 and 1
         }
HSVA.x = Hue;
HSVA.w = RGBA.w;
         return HSVA;
         }
//       ���������������������������������������������������������������������������������
//                 _____
//       _________/  2  \__________________________________________________________________
//       ����������������������������������������������������������������������������������
float4   HSVAtoRGBA      (    float4 HSVA      )
         {
         float Hue        = HSVA.x ;
         float Saturation = HSVA.y ;
         float Value      = HSVA.z;
         float ffff , pppp, qqqq, tttt;
         float HueFloor;
         float  R = 0 , G = 0 ,  B = 0;
         float4 RGBA;
         
         Hue    *= 360;
         
         if     ( Saturation == 0 )
                   {
                   if ( Value != 0 )
                                    { RGBA = Value ; }
                   }
                   
         else   {
                if ( Hue == 360.0 )
                                   { Hue = 0 ; }

                Hue /=60;
         
                HueFloor = floor ( Hue );
                ffff = Hue - HueFloor ;
                pppp = Value * ( 1.0 -   Saturation ) ;
                qqqq = Value * ( 1.0 - ( Saturation * ffff ) ) ;
                tttt = Value * ( 1.0 - ( Saturation * ( 1.0 -ffff  ) ) ) ;

                        if ( HueFloor == 0 )
                                             { R  = Value ; G  = tttt  ; B  = pppp  ; }
                   else if ( HueFloor == 1 ) { R  = qqqq  ; G  = Value ; B  = pppp  ; }
                   else if ( HueFloor == 2 ) { R  = pppp  ; G  = Value ; B  = tttt  ; }
                   else if ( HueFloor == 3 ) { R  = pppp  ; G  = qqqq  ; B  = Value ; }
                   else if ( HueFloor == 4 ) { R  = tttt  ; G  = pppp  ; B  = Value ; }
                   else if ( HueFloor == 5 ) { R  = Value ; G  = pppp  ; B  = qqqq  ; }

                RGBA.r = R ;
                RGBA.g = G ;
                RGBA.b = B ;
                RGBA.a = HSVA.a;
                }
         return RGBA;
         }
//       ����������������������������������������������������������������������������������
//                        _____
//       ________________/  3  \___________________________________________________________
//       ����������������������������������������������������������������������������������

float4   SiftHSV (
                 float4 InputColor ,
                 float4 ReferenceColor ,
                 float  HueRange,
                 float  SatRange,
                 float  ValRange
                 )
         {
         float InputHue          = RGBAtoHSVA (InputColor).x     ;
         float InputSat          = RGBAtoHSVA (InputColor).y     ;
         float InputVal          = RGBAtoHSVA (InputColor).z     ;
         float ReferenceHue      = RGBAtoHSVA (ReferenceColor).x ;
         float ReferenceSat      = RGBAtoHSVA (ReferenceColor).y ;
         float ReferenceVal      = RGBAtoHSVA (ReferenceColor).z ;

         float4 Result;

         float4 SWITCH =1.0f;
                     if   (
                            ( ( InputHue - ReferenceHue + 2 )  % 1 - 0.5f ) <= ( HueRange -0.5f )
                            && (abs(InputSat - ReferenceSat) < SatRange )
                            && (abs(InputVal - ReferenceVal) < ValRange )
                            )
                    SWITCH.rgb = 1.0f;
             else   SWITCH.rgb = 0.0f;

                    SWITCH  = smoothstep ( HueRange  , 0  ,abs( InputHue - ReferenceHue ) ) ;
                    SWITCH *= smoothstep ( SatRange  , 0 , abs( InputSat - ReferenceSat ) ) ;
                    SWITCH *= smoothstep ( ValRange  , 0 , abs( InputVal - ReferenceVal ) ) ;
             return SWITCH;
         }
//       ����������������������������������������������������������������������������������



//       _________________________________________________________________________________
//       ���������<   PIXEL SHADERS    >��������������������������������������������������
//       ���������������������������������������������������������������������������������
float4   Sift  ( vs2ps In ) : COLOR       //float4 replace (vs2ps In): COLOR
               {
               float4 Result  =  tex2D(Samp, In.TexCd );
               float4 Match =  lerp (
                                           ReplaceMatchRefColor                ,
                                    tex2D (       MatchReplaceSamp, In.TexCd ) ,
                                            SwitchMatchColTex
                                    ) ;
               float4 NONmatch =  lerp (
                                           ReplaceNONmatchRefColor                ,
                                    tex2D (       NONmatchReplaceSamp, In.TexCd ) ,
                                            SwitchNONmatchColTex
                                    ) ;
               //Result = saturate(Result );
               //
               
               Result  =  Match     *       SiftHSV ( Result ,RefCol, HueTol, SatTol, ValTol )
                       +  NONmatch  * ( 1  -SiftHSV ( Result ,RefCol, HueTol, SatTol, ValTol ) ) ;  // +
               
               //Result.a = 1;
               return Result;
               }

//        _________________________________________________________________________________
//        ���������<   TECHNIQUES    >�����������������������������������������������������
//        ���������������������������������������������������������������������������������
technique HSVSift //name for the technique pin
          {
          pass P0
               {
               VertexShader = compile vs_2_0 VS();
               PixelShader  = compile ps_2_0 Sift();
               }
          }
