#region usings
using System;
using System.ComponentModel.Composition;
using System.Globalization;
using System.Text.RegularExpressions;

using VVVV.PluginInterfaces.V1;
using VVVV.PluginInterfaces.V2;
using VVVV.Utils.VColor;
using VVVV.Utils.VMath;

using VVVV.Core.Logging;
#endregion usings


public class RegexUtilities
{
   bool invalid = false;
	// IdnMapping class with default property values.
   IdnMapping idn = new IdnMapping();
	
   public bool IsValidEmail(string strIn)
   {
       invalid = false;
       if (String.IsNullOrEmpty(strIn))
          return false;

       // Use IdnMapping class to convert Unicode domain names.
       strIn = Regex.Replace(strIn, @"(@)(.+)$", this.DomainMapper);
       if (invalid) 
          return false;

       // Return true if strIn is in valid e-mail format.
       return Regex.IsMatch(strIn, 
              @"^(?("")(""[^""]+?""@)|(([0-9a-z]((\.(?!\.))|[-!#\$%&'\*\+/=\?\^`\{\}\|~\w])*)(?<=[0-9a-z])@))" + 
              @"(?(\[)(\[(\d{1,3}\.){3}\d{1,3}\])|(([0-9a-z][-\w]*[0-9a-z]*\.)+[a-z0-9]{2,17}))$", 
              RegexOptions.IgnoreCase);
   }

   private string DomainMapper(Match match)
   {
      string domainName = match.Groups[2].Value;
      try {
         domainName = idn.GetAscii(domainName);
      }
      catch (ArgumentException) {
         invalid = true;      
      }      
      return match.Groups[1].Value + domainName;
   }
}

namespace VVVV.Nodes
{
	#region PluginInfo
	[PluginInfo(Name = "IsValidEmail", Category = "String", Help = "verifies that strings are in valid e-mail format", Tags = "", Author = "bjo:rn", Credits ="http://msdn.microsoft.com/en-us/library/01escwtf.aspx")]
	#endregion PluginInfo

	
	public class StringIsValidEmailNode : IPluginEvaluate
	{
		#region fields & pins
		[Input("Input", DefaultString = "test@domainname.net")]
		IDiffSpread<string> FInput;

		[Output("Output")]
		ISpread<bool> FOutput;

		[Import()]
		ILogger FLogger;
		#endregion fields & pins
		
		RegexUtilities util = new RegexUtilities();

		//called when data for any output pin is requested
		public void Evaluate(int SpreadMax)
		{
			
			if (FInput.IsChanged) {
			FOutput.SliceCount = SpreadMax;

			for (int i = 0; i < SpreadMax; i++)
				FOutput[i] = util.IsValidEmail(FInput[i]);
				
			}
			//FLogger.Log(LogType.Debug, "Logging to Renderer (TTY)");
		}
	}
}
