#region usings
using System;
using VVVV.PluginInterfaces.V1;
using VVVV.PluginInterfaces.V2;
#endregion usings

namespace VVVV.Nodes
{
	#region PluginInfo
	[PluginInfo(Name = "StringReplacer", Category = "String", Help = "Basic String Replacer (non-spreadable)", Tags = "replace,find,gilbi")]
	#endregion PluginInfo
	public class StringStringReplacerNode : IPluginEvaluate
	{
		#region fields & pins
		[Input("Input", DefaultString = "text")]
		ISpread<string> fInput;
		
		[Input("Replacements", DefaultString = "")]
		ISpread<string> fReplacements;
		
		[Input("Enabled")]
		ISpread<bool> fEnabled;
		
		[Output("Output")]
		ISpread<string> FOutput;
		#endregion fields & pins

		//called when data for any output pin is requested
		public void Evaluate(int SpreadMax)
		{
			if (fEnabled[0]) {
				
				FOutput[0] = fInput[0];
				
				for (int i = 1; i-1 < fReplacements.SliceCount; i++) {
					FOutput[0] = FOutput[0].Replace("$"+(i.ToString("D")), fReplacements[i]);
					
				}
			}
		}
	}
}
