#region usings
using System;
using VVVV.PluginInterfaces.V1;
using VVVV.PluginInterfaces.V2;
#endregion usings

namespace VVVV.Nodes
{
	#region PluginInfo
	[PluginInfo(Name = "StringReplacerSpreadable", Category = "String", Help = "Basic String Replacer (spreadable)", Tags = "replace,find,gilbi")]
	#endregion PluginInfo
	public class StringStringReplacerSpreadableNode : IPluginEvaluate
	{
		#region fields & pins
		[Input("Input", DefaultString = "text")]
		ISpread<string> fInput;

		[Input("Replace $1", DefaultString = "")]
		ISpread<string> fR1;

		[Input("Replace $2", DefaultString = "")]
		ISpread<string> fR2;

		[Input("Replace $3", DefaultString = "")]
		ISpread<string> fR3;

		[Input("Replace $4", DefaultString = "")]
		ISpread<string> fR4;

		[Input("Replace $5", DefaultString = "")]
		ISpread<string> fR5;

		[Input("Replace $6", DefaultString = "")]
		ISpread<string> fR6;

		[Input("Replace $7", DefaultString = "")]
		ISpread<string> fR7;

		[Input("Replace $8", DefaultString = "")]
		ISpread<string> fR8;

		[Input("Replace $9", DefaultString = "")]
		ISpread<string> fR9;

		[Input("Replace $10", DefaultString = "")]
		ISpread<string> fR10;

		[Input("Replace $11", DefaultString = "")]
		ISpread<string> fR11;

		[Input("Replace $12", DefaultString = "")]
		ISpread<string> fR12;
		
		[Input("Number of Replacements", DefaultValue = 1)]
		ISpread<int> fReplacementCount;

		[Input("Enabled")]
		ISpread<bool> fEnabled;

		[Output("Output")]
		ISpread<string> FOutput;
		#endregion fields & pins

		//called when data for any output pin is requested
		public void Evaluate(int SpreadMax)
		{
			if (fEnabled[0]) {
				
				int rcount = fReplacementCount[0];
				
				FOutput.SliceCount = SpreadMax;
				
				for (int i = 0; i < SpreadMax; i++) {
					FOutput[i] = fInput[i];
					switch (rcount) {
						case 1:
							FOutput[i] = FOutput[i]
								.Replace("$1", fR1[i]);
						break;
						case 2:
							FOutput[i] = FOutput[i]
								.Replace("$1", fR1[i])
								.Replace("$2", fR2[i]);
						break;
						case 3:
							FOutput[i] = FOutput[i]
								.Replace("$1", fR1[i])
								.Replace("$2", fR2[i])
								.Replace("$3", fR3[i]);
						break;
						case 4:
							FOutput[i] = FOutput[i]
								.Replace("$1", fR1[i])
								.Replace("$2", fR2[i])
								.Replace("$3", fR3[i])
								.Replace("$4", fR4[i]);
						break;
						case 5:
							FOutput[i] = FOutput[i]
								.Replace("$1", fR1[i])
								.Replace("$2", fR2[i])
								.Replace("$3", fR3[i])
								.Replace("$4", fR4[i])
								.Replace("$5", fR5[i]);
						break;
						case 6:
							FOutput[i] = FOutput[i]
								.Replace("$1", fR1[i])
								.Replace("$2", fR2[i])
								.Replace("$3", fR3[i])
								.Replace("$4", fR4[i])
								.Replace("$5", fR5[i])
								.Replace("$6", fR6[i]);
						break;
						case 7:
							FOutput[i] = FOutput[i]
								.Replace("$1", fR1[i])
								.Replace("$2", fR2[i])
								.Replace("$3", fR3[i])
								.Replace("$4", fR4[i])
								.Replace("$5", fR5[i])
								.Replace("$6", fR6[i])
								.Replace("$7", fR7[i]);
						break;
						case 8:
							FOutput[i] = FOutput[i]
								.Replace("$1", fR1[i])
								.Replace("$2", fR2[i])
								.Replace("$3", fR3[i])
								.Replace("$4", fR4[i])
								.Replace("$5", fR5[i])
								.Replace("$6", fR6[i])
								.Replace("$7", fR7[i])
								.Replace("$8", fR8[i]);
						break;
						case 9:
							FOutput[i] = FOutput[i]
								.Replace("$1", fR1[i])
								.Replace("$2", fR2[i])
								.Replace("$3", fR3[i])
								.Replace("$4", fR4[i])
								.Replace("$5", fR5[i])
								.Replace("$6", fR6[i])
								.Replace("$7", fR7[i])
								.Replace("$8", fR8[i])
								.Replace("$9", fR9[i]);
						break;
						case 10:
							FOutput[i] = FOutput[i]
								.Replace("$1", fR1[i])
								.Replace("$2", fR2[i])
								.Replace("$3", fR3[i])
								.Replace("$4", fR4[i])
								.Replace("$5", fR5[i])
								.Replace("$6", fR6[i])
								.Replace("$7", fR7[i])
								.Replace("$8", fR8[i])
								.Replace("$9", fR9[i])
								.Replace("$10", fR10[i]);
						break;
						case 11:
							FOutput[i] = FOutput[i]
								.Replace("$1", fR1[i])
								.Replace("$2", fR2[i])
								.Replace("$3", fR3[i])
								.Replace("$4", fR4[i])
								.Replace("$5", fR5[i])
								.Replace("$6", fR6[i])
								.Replace("$7", fR7[i])
								.Replace("$8", fR8[i])
								.Replace("$9", fR9[i])
								.Replace("$10", fR10[i])
								.Replace("$11", fR11[i]);
						break;
						case 12:
							FOutput[i] = FOutput[i]
								.Replace("$1", fR1[i])
								.Replace("$2", fR2[i])
								.Replace("$3", fR3[i])
								.Replace("$4", fR4[i])
								.Replace("$5", fR5[i])
								.Replace("$6", fR6[i])
								.Replace("$7", fR7[i])
								.Replace("$8", fR8[i])
								.Replace("$9", fR9[i])
								.Replace("$10", fR10[i])
								.Replace("$11", fR11[i])
								.Replace("$12", fR12[i]);
						break;
					}
				}
			}			
		}
	}
}
