#region usings
using System;
using VVVV.PluginInterfaces.V1;
using VVVV.PluginInterfaces.V2;
#endregion usings

namespace VVVV.Nodes
{
	#region PluginInfo
	[PluginInfo(Name = "StringReplacerUnlimited", Category = "String", Help = "String Replacer Unlimited (semi-spreadable)", Tags = "replace,find,gilbi")]
	#endregion PluginInfo
	public class StringStringReplacerUnlimitedNode : IPluginEvaluate
	{
		#region fields & pins
		[Input("Input", DefaultString = "text")]
		ISpread<string> fInput;

		[Input("Replacements", DefaultString = "")]
		ISpread<string> fReplacements;

		[Input("Enabled")]
		ISpread<bool> fEnabled;

		[Output("Output")]
		ISpread<string> FOutput;
		#endregion fields & pins

		//called when data for any output pin is requested
		public void Evaluate(int SpreadMax)
		{
			if (fEnabled[0]) {

				int rcount = fReplacements.SliceCount / fInput.SliceCount;

				if (fReplacements.SliceCount < rcount * fInput.SliceCount) {
					FOutput[0] = "Error: Replacements spread too small!";
					return;
				}

				for (int j = 0; j < fInput.SliceCount; j++) {
					FOutput[j] = fInput[j];
					for (int i = 0; i < rcount; i++) {
						FOutput[j] = FOutput[j].Replace("$" + (i + 1).ToString("D"), fReplacements[i * rcount + j]);
					}
				}
			}			
		}
	}
}
