#region usings
using System;
using System.ComponentModel.Composition;

using VVVV.PluginInterfaces.V1;
using VVVV.PluginInterfaces.V2;
using VVVV.Utils.VColor;
using VVVV.Utils.VMath;

using VVVV.Core.Logging;
#endregion usings

namespace VVVV.Nodes
{
	#region PluginInfo
	[PluginInfo(Name = "UpTime", Category = "System", Help = "Basic template with one string in/out", Tags = "")]
	#endregion PluginInfo
	public class SystemUpTimeNode : IPluginEvaluate
	{
		#region fields & pins

		[Output("Windows Up Time")]
		ISpread<string> FOutput;

		[Import()]
		ILogger FLogger;
		#endregion fields & pins

		
		class Sample 
		{
		    public static void Main() 
		    {
		    int result = Environment.TickCount & Int32.MaxValue;
		    Console.WriteLine("TickCount: {0}", result);
		    }
		}
		
		
		//called when data for any output pin is requested
		public void Evaluate(int SpreadMax)
		{
			FOutput.SliceCount = 1;

			int result = Environment.TickCount & Int32.MaxValue;
			FOutput[0] = result.ToString();

			//FLogger.Log(LogType.Debug, "Logging to Renderer (TTY)");
		}
	}
}
