
Texture2D trgTex <string uiname="Target Texture";>;

struct trgStruct
{
	float3 pos;
	float strength;
	uint index;
};
AppendStructuredBuffer<trgStruct> Output : BACKBUFFER;

int2 res;

float threshold = 0.001;

// =============================================================================
// =============================================================================
// =============================================================================
// =============================================================================
// =============================================================================
// =============================================================================

[numthreads(32, 1, 1)]
void SelectTargets_CS(	uint3 DTid : SV_DispatchThreadID)
{	
	if(	DTid.x >= (uint)res.x || DTid.y >= (uint)res.y) return;
	
	float4 texData = trgTex.Load(DTid);
	
	if(texData.w > threshold)
	{
		trgStruct Out;
		Out.pos = texData.xyz;
		Out.strength = texData.w;
		Out.index = DTid.x + DTid.y * res.x;
		Output.Append(Out);
	}
}

// =============================================================================
// =============================================================================
// =============================================================================
// =============================================================================
// =============================================================================
// =============================================================================

technique11 SelectTargets
{
	pass P0
	{	SetComputeShader(CompileShader( cs_5_0, SelectTargets_CS() ) );	}
}




