#region usings
using System;
using System.ComponentModel.Composition;

using VVVV.PluginInterfaces.V1;
using VVVV.PluginInterfaces.V2;
using VVVV.Utils.VColor;
using VVVV.Utils.VMath;

using VVVV.Core.Logging;
#endregion usings

namespace VVVV.Nodes
{
	#region PluginInfo
	[PluginInfo(Name = "Mirror", Category = "Value", Help = "Mirror: multiply with (-1,1)", Tags = "mirror, bi, negative, complementary", Author = "lichterloh")]
	#endregion PluginInfo
	public class ValueBiNode : IPluginEvaluate
	{
		#region fields & pins
		[Input("Input", DefaultValue = 1.0)]
		public ISpread<ISpread<double>> FInput;
		
//		[Input("BinSize", DefaultValue = -1, Visibility = PinVisibility.Hidden)]
//		public ISpread<int> FBinSize;
		
		
		[Input("Reverse", DefaultValue = 0)]
		public ISpread<bool> FReverse;
		
		
		[Output("Output")]
		public ISpread<double> FOutput;
	

		[Import()]
		public ILogger FLogger;
		#endregion fields & pins

		//called when data for any output pin is requested
		public void Evaluate(int SpreadMax)
		{
			int z = FInput.SliceCount;
			
			FOutput.SliceCount = z*2;
			int[] binSize = new int[z];
			int[] binSum = new int[z];
	
			for (int i = 0; i < z; i++)
			{
			
				int x = FInput[i].SliceCount;
				binSize[i] = x*2;
				binSum[0] = 0;
				
			for (int r = 1; r < z; r++)
				{
					binSum[r] = binSize[r - 1] + binSum[r - 1];
				}
				
				int j = binSum[i];
				int k = j+x;
				
			    for (int s = 0; s < FInput[i].SliceCount; s++)
				{
				switch (FReverse[i]){
					
					case (false):
					FOutput[j+s] = FInput[i][s]*(-1.0);
					FOutput[k+s] = FInput[i][s];
					break;
					
					case (true):
					FOutput[j+s] = FInput[i][s];
					FOutput[k+s] = FInput[i][s]*(-1.0);
					break;
									}
				
				}
			}
				
		}
			
	}
	
}
	

	

