#region usings
using System;
using System.ComponentModel.Composition;

using VVVV.PluginInterfaces.V1;
using VVVV.PluginInterfaces.V2;
using VVVV.Utils.VColor;
using VVVV.Utils.VMath;

using VVVV.Core.Logging;
#endregion usings

namespace VVVV.Nodes
{
	#region PluginInfo
	[PluginInfo(Name = "Mirror", Category = "Value", Help = "Mirror: multiply with (-1,1)", Tags = "mirror, bi, negative, complementary", Author = "lichterloh, bildwerk")]
	#endregion PluginInfo
	public class ValueBiNode : IPluginEvaluate
	{
		#region fields & pins
		[Input("Input", DefaultValue = 1.0)]
		public ISpread<ISpread<double>> FInput;
		
		
		[Input("Reverse", DefaultValue = 0)]
		public ISpread<bool> FReverse;
		
		
		[Output("Output")]
		public ISpread<double> FOutput;
		
		[Output("Debug")]
		public ISpread<int> FDebug;
	

		[Import()]
		public ILogger FLogger;
		#endregion fields & pins
		
		
		int[] binSize;
        int[] binSum;
        int oldSize = 0;

        public int[] OnSpreadChange(int[] array, int z)
        {
            return new int[z];
        }

		//called when data for any output pin is requested
		public void Evaluate(int SpreadMax)
		{
			int SliceCountIn = FInput.GetSliceCountSum();
			
			if (SliceCountIn != oldSize || binSize == null || binSum == null)
            {
                binSize = OnSpreadChange(binSize, SliceCountIn);
                binSum = OnSpreadChange(binSum, SliceCountIn);
                oldSize = SliceCountIn;
            }
			
			
			FOutput.SliceCount = SliceCountIn*2;

	
			for (int i = 0; i < SliceCountIn; i++)
			{
			
				int x = FInput[i].SliceCount;
				binSize[i] = x*2;
				binSum[0] = 0;
//				FDebug[0] = SliceCountIn;
				
			for (int r = 1; r < SliceCountIn; r++)
				{
					binSum[r] = binSize[r - 1] + binSum[r - 1];
				}
				
				int j = binSum[i];
				int k = j+x;
				
			    for (int s = 0; s < FInput[i].SliceCount; s++)
				{
				switch (FReverse[i]){
					
					case (false):
					FOutput[j+s] = FInput[i][s]*(-1.0);
					FOutput[k+s] = FInput[i][s];
					break;
					
					case (true):
					FOutput[j+s] = FInput[i][s];
					FOutput[k+s] = FInput[i][s]*(-1.0);
					break;
									}
				
				}
			}
				
		}
			
	}
	
}
	

	

