#region usings
using DAP.CompGeom;
using VVVV.PluginInterfaces.V2;

#endregion usings

namespace VVVV.Nodes
{
    #region PluginInfo
    [PluginInfo(Name = "CellInfo", Category = "2d.Voronoi", Help = "Returns voronoi cell information", Tags = "Voronoi, Delaunay")]
    #endregion PluginInfo
    public class CellInfo : IPluginEvaluate
    {
        #region fields & pins
        [Input("Cell")] 
        public IDiffSpread<FortunePoly> Cell;

        [Output("Center")]
        public ISpread<double> Center;

        [Output("Index")]
        public ISpread<int> Index;

        [Output("Is at Infinity")]
        public ISpread<bool> FAtInfinity;

        [Output("Edges")]
        public ISpread<FortuneEdge> Edges;

        [Output("Vertices")]
        public ISpread<FortuneVertex> Vertices;

        [Output("Bin Size")]
        public ISpread<int> BinSizes;
        #endregion fields & pins

        //called when data for any output pin is requested
        public void Evaluate(int spreadMax)
        {
	        if (!Cell.IsChanged)
	        {
		        return;
	        }
            FAtInfinity.SliceCount = spreadMax;
	        Center.SliceCount =
		        FAtInfinity.SliceCount =
				Index.SliceCount =
			    Edges.SliceCount =
				Vertices.SliceCount = 
				BinSizes.SliceCount = 0;

            for (var icell = 0; icell < spreadMax; icell++)
            {
                var cell = Cell[icell];
	            if (cell == null)
	            {
		            continue;
	            }
                Center.Add(cell.VoronoiPoint.X);
                Center.Add(cell.VoronoiPoint.Y);
                FAtInfinity.Add(cell.FAtInfinity);
                if (cell.FAtInfinity)
                {
                    Index.Add(-1);
                }
                else
                {
                    Index.Add((int)cell.Cookie);
                }
                var cCellsEdges = 0;
                foreach (var edge in cell.Edges)
                {
                    cCellsEdges++;
                    Edges.Add(edge as FortuneEdge);
                }
                BinSizes.Add(cCellsEdges);
                foreach (var vertex in cell.Vertices)
                {
                    Vertices.Add(vertex as FortuneVertex);
                }
            }
        }
    }
}
