﻿#region usings

using System.Linq;
using DAP.CompGeom;
using VVVV.PluginInterfaces.V2;
#endregion usings

namespace VVVV.Nodes
{
	#region PluginInfo
	[PluginInfo(Name = "Edges", Category = "2d.Voronoi", Help = "Returns voronoi edges", Tags = "Voronoi, Delaunay")]
	#endregion PluginInfo
	public class Edges : IPluginEvaluate
	{
		#region fields & pins
		[Input("Voronoi Complex")] 
		public IDiffSpread<WingedEdge<FortunePoly, FortuneEdge, FortuneVertex>> ComplexIn;

	    [Input("Include Edges at Infinity", DefaultBoolean = false)]
		public IDiffSpread<bool> FIncludeInfinite;

		[Input("Include Rays", DefaultBoolean = true)]
		public IDiffSpread<bool> FIncludeRays;

		[Output("Edges")] public ISpread<FortuneEdge> EdgesSprd;
		#endregion fields & pins

		//called when data for any output pin is requested
		public void Evaluate(int spreadMax)
		{
			if (!ComplexIn.IsChanged && !FIncludeInfinite.IsChanged && !FIncludeRays.IsChanged)
			{
				return;
			}
			var complexIn = ComplexIn[0];
			if (complexIn == null)
			{
				return;
			}
		    var fIncludeInfinite = FIncludeInfinite[0];
		    var fIncludeRays = FIncludeRays[0];

			EdgesSprd.SliceCount = 0;
			foreach (var edge in complexIn.LstEdges.Where(edge => (fIncludeInfinite || !edge.FAtInfinity) && (fIncludeRays || !edge.FRay)))
			{
				EdgesSprd.Add(edge);
			}
		}
	}
}