﻿#region usings

using System.Collections.Generic;
using DAP.CompGeom;
using VVVV.PluginInterfaces.V2;
using VVVV.Utils.VMath;

#endregion usings

namespace VVVV.Nodes
{
	#region PluginInfo
	[PluginInfo(Name = "LloydRelaxation", Category = "2d.Voronoi", Help = "Relaxes a Voronoi complex", Tags = "Voronoi, Delaunay")]
	#endregion PluginInfo
	public class LloydRelaxation : IPluginEvaluate
	{
		#region fields & pins
		[Input("Voronoi Complex")]
		public IDiffSpread<WingedEdge<FortunePoly, FortuneEdge, FortuneVertex>> Complx;

		[Input("Clipping Polygon")]
		public IDiffSpread<Vector2D> Clip;

		[Input("Infinite Ray Multiplier", DefaultValue = 100.0)]
		public IDiffSpread<double> RayMult;

		[Input("Iterations", DefaultValue = 1, MinValue = 0)]
		public IDiffSpread<int> Iterations;

		[Output("Relaxed Voronoi Complex")]
		public ISpread<WingedEdge<FortunePoly, FortuneEdge, FortuneVertex>> ComplxOut;
		#endregion fields & pins

		//called when data for any output pin is requested
		public void Evaluate(int spreadMax)
		{
			if (!Complx.IsChanged && !Iterations.IsChanged && !RayMult.IsChanged && !Clip.IsChanged)
			{
				return;
			}

			var cmplx = Complx[0];
			if (cmplx == null)
			{
				ComplxOut.SliceCount = 0;
				return;
			}

			ComplxOut.SliceCount = 1;
			var clip = new List<PointD>(Clip.SliceCount);
			for (var iClip = 0; iClip < Clip.SliceCount; iClip++)
			{
				clip.Add(new PointD(Clip[iClip].x, Clip[iClip].y));
			}
			for (var iIter = 0; iIter < Iterations[0]; iIter++)
			{
				cmplx = Fortune.LloydRelax(cmplx, RayMult[0], clip);
			}
			ComplxOut[0] = cmplx;
		}
	}
}
