﻿#region usings

using System.Linq;
using DAP.CompGeom;
using VVVV.PluginInterfaces.V2;
#endregion usings

namespace VVVV.Nodes
{
	#region PluginInfo
	[PluginInfo(Name = "Cells", Category = "2d.Voronoi", Help = "Returns voronoi cells", Tags = "Voronoi, Delaunay")]
	#endregion PluginInfo
	public class Cells : IPluginEvaluate
	{
		#region fields & pins
		[Input("Voronoi Complex")]
		public IDiffSpread<WingedEdge<FortunePoly, FortuneEdge, FortuneVertex>> ComplexIn;

        [Input("Include Cell at Infinity", DefaultBoolean = false)]
		public IDiffSpread<bool> FIncludeInfinite;

		[Output("Cells")]
		public ISpread<FortunePoly> CellsSprd;
		#endregion fields & pins

		//called when data for any output pin is requested
		public void Evaluate(int spreadMax)
		{
			if (!ComplexIn.IsChanged && !FIncludeInfinite.IsChanged)
			{
				return;
			}
			var complexIn = ComplexIn[0];
			if (complexIn == null)
			{
				return;
			}
		    var fIncludeInfinite = FIncludeInfinite[0];
			CellsSprd.SliceCount = 0;
			foreach (var poly in complexIn.LstPolygons.Where(poly => fIncludeInfinite || !poly.FAtInfinity))
			{
				CellsSprd.Add(poly);
			}
		}
	}
}