﻿#region usings
using DAP.CompGeom;
using VVVV.PluginInterfaces.V2;

#endregion usings

namespace VVVV.Nodes
{
	#region PluginInfo
	[PluginInfo(Name = "EdgeInfo", Category = "2d.Voronoi", Help = "Returns voronoi edge information", Tags = "Voronoi, Delaunay")]
	#endregion PluginInfo
	public class EdgeInfo : IPluginEvaluate
	{
		#region fields & pins
		[Input("Edge")] 
		public IDiffSpread<FortuneEdge> Edge;

		[Output("Start")]
		public ISpread<FortuneVertex> Start;

		[Output("End")] 
		public ISpread<FortuneVertex> End;

		[Output("Is Ray")]
		public ISpread<bool> FRay;

		[Output("Is at Infinity")] 
		public ISpread<bool> FAtInfinity;

		[Output("Left Cell")] 
		public ISpread<FortunePoly> LeftPoly;

		[Output("Right Cell")] 
		public ISpread<FortunePoly> RightPoly;

		[Output("Start CCW")] 
		public ISpread<FortuneEdge> CcwPred;

		[Output("Start CW")] 
		public ISpread<FortuneEdge> CwPred;

		[Output("End CCW")] 
		public ISpread<FortuneEdge> CcwSucc;

		[Output("End CW")] 
		public ISpread<FortuneEdge> CwSucc;

		[Output("Index")] 
		public ISpread<int> Index; 
		#endregion fields & pins

		//called when data for any output pin is requested
		public void Evaluate(int spreadMax)
		{
			if (!Edge.IsChanged)
			{
				return;
			}
			Start.SliceCount =
				End.SliceCount =
				LeftPoly.SliceCount =
				RightPoly.SliceCount =
				CcwPred.SliceCount =
				CwPred.SliceCount =
				CcwSucc.SliceCount =
				CwSucc.SliceCount =
				FRay.SliceCount = 
				Index.SliceCount =
				FAtInfinity.SliceCount = Edge.SliceCount;

			for (var i = 0; i < spreadMax; i++)
			{
				var edge = Edge[i];
				if (edge == null)
				{
					continue;
				}
				Start[i] = edge.VtxStart as FortuneVertex;
				End[i] = edge.VtxEnd as FortuneVertex;
				FRay[i] = edge.FRay;
				FAtInfinity[i] = edge.FAtInfinity;
				LeftPoly[i] = edge.PolyLeft as FortunePoly;
				RightPoly[i] = edge.PolyRight as FortunePoly;
				CcwPred[i] = edge.EdgeCCWPredecessor as FortuneEdge;
				CwPred[i] = edge.EdgeCWPredecessor as FortuneEdge;
				CcwSucc[i] = edge.EdgeCCWSuccessor as FortuneEdge;
				CwSucc[i] = edge.EdgeCWSuccessor as FortuneEdge;
				Index[i] = (int) edge.Cookie;
			}
		}
	}
}
