#region usings
using System.Collections.Generic;
using DAP.CompGeom;
using VVVV.PluginInterfaces.V2;
using VVVV.Utils.VMath;
#endregion usings

namespace VVVV.Nodes
{
	#region PluginInfo
	[PluginInfo(Name = "VoronoiComplex", Category = "2d.Voronoi", Help = "Returns voronoi information", Tags = "Voronoi, Delaunay")]
	#endregion PluginInfo
	public class VoronoiComplex : IPluginEvaluate
	{
		#region fields & pins
		[Input("Points", DefaultValue = 0.0)]
		public IDiffSpread<Vector2D> Points;

		[Output("Voronoi Complex")]
		public ISpread<WingedEdge<FortunePoly, FortuneEdge, FortuneVertex>> ComplxOut;
		#endregion fields & pins

		//called when data for any output pin is requested
		public void Evaluate(int spreadMax)
		{
			if (!Points.IsChanged)
			{
				return;
			}
			ComplxOut.SliceCount = 1;
			var points = new List<PointD>(spreadMax);

			for (var i = 0; i < spreadMax; i++)
			{
				points.Add(new PointD(Points[i].x, Points[i].y));
			}
			var newComplex = Fortune.ComputeVoronoi(points);
			for (var iVtx = 0; iVtx < newComplex.LstVertices.Count; iVtx++)
			{
				newComplex.LstVertices[iVtx].Cookie = iVtx;
			}
			for (var iEdge = 0; iEdge < newComplex.LstEdges.Count; iEdge++)
			{
				newComplex.LstEdges[iEdge].Cookie = iEdge;
			}
			ComplxOut[0] = newComplex;
		}
	}
}
