#region usings
using System.Linq;
using DAP.CompGeom;
using VVVV.PluginInterfaces.V2;
#endregion usings

namespace VVVV.Nodes
{
	#region PluginInfo
	[PluginInfo(Name = "Diagram", Category = "2d.Voronoi", Help = "Retrieve edge lines for voronoi object", Tags = "Voronoi, Delaunay")]
	#endregion PluginInfo
	public class Diagram : IPluginEvaluate
	{
		#region fields & pins
		[Input("Voronoi Complex")]
		public IDiffSpread<WingedEdge<FortunePoly, FortuneEdge, FortuneVertex>> ComplxIn;

		[Input("Infinite Ray Multiplier", DefaultValue = 100.0)]
		public IDiffSpread<double> RayMult;

		[Output("Edge VerticesXY")]
		public ISpread<double> Lines;
		#endregion fields & pins

		//called when data for any output pin is requested
		public void Evaluate(int spreadMax)
		{
			if (!ComplxIn.IsChanged && !RayMult.IsChanged)
			{
				return;
			}
			if (ComplxIn[0] == null)
			{
				Lines.SliceCount = 0;
				return;
			}
			var voronoi = ComplxIn[0];
			var rayMult = RayMult[0];

			Lines.SliceCount = 4 * voronoi.LstEdges.Count;

			var lc = 0;
			foreach (var edge in voronoi.LstEdges.Where(edge => !edge.FAtInfinity))
			{
				Lines[4 * lc] = edge.VtxStart.Pt.X;
				Lines[4 * lc + 1] = edge.VtxStart.Pt.Y;
				if (edge.FRay)
				{
					Lines[4 * lc + 2] = edge.VtxStart.Pt.X + edge.VtxEnd.Pt.X * rayMult;
					Lines[4 * lc + 3] = edge.VtxStart.Pt.Y + edge.VtxEnd.Pt.Y * rayMult;
				}
				else
				{
					Lines[4 * lc + 2] = edge.VtxEnd.Pt.X;
					Lines[4 * lc + 3] = edge.VtxEnd.Pt.Y;
				}
				lc++;
			}

			Lines.SliceCount = 4 * lc;
		}
	}

}
