//@author: antokhio
//@help: A simple combination of vertex and pixel shaders with velvety edge effects.
//@tags: effects, material 
//@credits: dottore, nvidia

Texture2D tex0;
SamplerState s0:IMMUTABLE {Filter=MIN_MAG_MIP_LINEAR;AddressU=CLAMP;AddressV=CLAMP;};

float4x4 tW : WORLD;
float4x4 tVP : VIEWPROJECTION;
float4x4 tWIT : WORLDINVERSETRANSPOSE;
float4x4 tVI : VIEWINVERSE;


float3 LampPos <string uiname="Lamp Position";>;
//float4 Lamp0Color <bool color=true;String uiname="Lamp Specular";> = {0.15, 0.15, 0.15, 1};
float4 SurfaceColor <bool color=true;String uiname="Ambient Color";> = {0.15, 0.15, 0.15, 1};
float4 FuzzySpecColor <bool color=true;String uiname="Fuzzy Color";> = {0.15, 0.15, 0.15, 1};
float4 SubColor<bool color=true;String uiname="Subtract Color";> = {0.15, 0.15, 0.15, 1};

float RollOff = 0.3;


float4x4 tTex <string uiname="Texture Transform";>;
float4x4 tColor <string uiname="Color Transform";>;

struct VS_IN
{
	float4 pos : POSITION;
	float4 uv : TEXCOORD0;
	float4 normal : NORMAL;
};

struct VS_OUT_0
{
    float4 pos: SV_POSITION;
    float4 uv: TEXCOORD0;
	float4 diffCol	: COLOR0;
	float4 specCol	: COLOR1;
};

struct VS_OUT_1
{
    float4 pos: SV_POSITION;
    float4 uv: TEXCOORD0;
	float3 LightVec	: TEXCOORD1;
	float3 WorldNormal	: TEXCOORD2;
	float3 WorldView	: TEXCOORD5;
};



VS_OUT_0 VS0(VS_IN input)
{
    VS_OUT_0 output;
	
	float3 Nn = normalize(mul(input.normal,tWIT).xyz);
    float4 Po = input.pos;
    output.pos = mul(Po,mul (tW,tVP));
    float3 Pw = mul(Po,tW).xyz;
    float3 Ln = normalize(LampPos - Pw);
    float ldn = dot(Ln,Nn);
    float diffComp = max(0,ldn);
    float3 diffContrib = diffComp * SurfaceColor.rgb;
    float subLamb = smoothstep(-RollOff,1.0,ldn) - smoothstep(0.0,1.0,ldn);
    subLamb = max(0.0,subLamb);
    float3 subContrib = subLamb * SubColor.rgb;
    output.uv = mul (input.uv,tTex);
    float3 Vn = normalize(tVI[3].xyz - Pw);
    float vdn = 1.0-dot(Vn,Nn);
    float3 vecColor = vdn.xxx;
    output.diffCol = float4((subContrib+diffContrib).xyz,1);
    output.specCol = float4((vecColor*FuzzySpecColor.xyz).xyz,0);
	

	
    return output;
}

VS_OUT_1 VS1 (VS_IN input)
{
	VS_OUT_1 output;
	
	float3 Nn = normalize(mul(input.normal,tWIT).xyz);
    float4 Po = input.pos;
    
    float3 Pw = mul(Po,tW).xyz;
	
	
	
	float4 Lo = float4(LampPos.xyz,1.0);
	float4 Lw = mul(Lo,tW);
	
	output.pos = mul(Po,mul (tW,tVP));
	output.uv = mul (input.uv,tTex);
	output.LightVec = (LampPos - Pw.xyz);
	output.WorldView = normalize(tVI[3].xyz - Pw.xyz);
	output.WorldNormal =  mul(input.normal,tWIT).xyz;
	
	return output;
	
}

void velvet_shared (VS_OUT_1 IN, float3 SurfaceColor, float3 FuzzySpecColor, float3 SubColor, float RollOff, out float4 DiffuseContrib, out float4 SpecularContrib)
{
	float3 Ln = normalize(IN.LightVec.xyz);
    float3 Nn = normalize(IN.WorldNormal);
    float3 Vn = normalize(IN.WorldView);
    float3 Hn = normalize(Vn + Ln);
    float ldn = dot(Ln,Nn);
    float diffComp = max(0,ldn);
    float vdn = 1 - dot(Vn,Nn) ;
    float3 diffContrib = diffComp * SurfaceColor;
    float subLamb = smoothstep(-RollOff,1.0,ldn) - smoothstep(0.0,1.0,ldn);
    subLamb = max(0.0,subLamb);
    float3 subContrib = subLamb * SubColor;
    float3 vecColor = vdn.xxx;
    DiffuseContrib = float4 (subContrib+diffContrib , 1);
    SpecularContrib = float4 (vecColor*FuzzySpecColor , 0);
}

float4 PS0(VS_OUT_0 input): SV_Target
{
	float4 result = input.specCol + (tex0.Sample(s0, input.uv.xy) * input.diffCol);
    return mul(result, tColor);
}

float4 PS1(VS_OUT_1 input): SV_Target
{
	float4 diffContrib, specContrib;
	velvet_shared(input,SurfaceColor.xyz,FuzzySpecColor.xyz,SubColor.xyz,RollOff,diffContrib,specContrib);
	float4 result = specContrib + (tex0.Sample(s0, input.uv.xy) * diffContrib);
    return mul(result, tColor);
}

technique10 PS_Velvety
{
	pass P0
	{
		SetVertexShader( CompileShader( vs_4_0, VS1() ) );
		SetPixelShader( CompileShader( ps_4_0, PS1() ) );
	}
}

technique10 VS_Velvety
{
	pass P0
	{
		SetVertexShader( CompileShader( vs_4_0, VS0() ) );
		SetPixelShader( CompileShader( ps_4_0, PS0() ) );
	}
}



